/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumValidator;
import com.sleepycat.je.log.DbChecksumException;
import com.sleepycat.je.log.FileHandle;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public abstract class FileReader {
    protected EnvironmentImpl env;
    protected FileManager fileManager;
    private ByteBuffer readBuffer;
    private ByteBuffer saveBuffer;
    private int maxReadBufferSize;
    private boolean singleFile;
    protected boolean eof;
    private boolean forward;
    protected long readBufferFileNum;
    protected long readBufferFileStart;
    protected long readBufferFileEnd;
    private int nRead;
    private long nRepeatIteratorReads;
    protected byte currentEntryTypeNum;
    protected byte currentEntryTypeVersion;
    protected long currentEntryPrevOffset;
    protected int currentEntrySize;
    protected long currentEntryChecksum;
    protected long currentEntryOffset;
    protected long nextEntryOffset;
    protected long startLsn;
    private long finishLsn;
    protected ChecksumValidator cksumValidator;
    private boolean doValidateChecksum;
    private boolean alwaysValidateChecksum;
    protected boolean anticipateChecksumErrors;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileReader(EnvironmentImpl env, int readBufferSize, boolean forward, long startLsn, Long singleFileNumber, long endOfFileLsn, long finishLsn) throws IOException, DatabaseException {
        this.env = env;
        this.fileManager = env.getFileManager();
        this.doValidateChecksum = env.getLogManager().getChecksumOnRead();
        this.singleFile = singleFileNumber != null;
        this.forward = forward;
        this.readBuffer = ByteBuffer.allocate(readBufferSize);
        this.threadSafeBufferFlip(this.readBuffer);
        this.saveBuffer = ByteBuffer.allocate(readBufferSize);
        DbConfigManager configManager = env.getConfigManager();
        this.maxReadBufferSize = configManager.getInt(EnvironmentParams.LOG_ITERATOR_MAX_SIZE);
        this.startLsn = startLsn;
        this.finishLsn = finishLsn;
        this.initStartingPosition(endOfFileLsn, singleFileNumber);
        this.nRead = 0;
        if (this.doValidateChecksum) {
            this.cksumValidator = new ChecksumValidator();
        }
        this.anticipateChecksumErrors = false;
    }

    protected void initStartingPosition(long endOfFileLsn, Long ignoreSingleFileNumber) throws IOException, DatabaseException {
        this.eof = false;
        if (this.forward) {
            if (this.startLsn != -1L) {
                this.readBufferFileNum = DbLsn.getFileNumber(this.startLsn);
                this.readBufferFileEnd = DbLsn.getFileOffset(this.startLsn);
            } else {
                Long firstNum = this.fileManager.getFirstFileNum();
                if (firstNum == null) {
                    this.eof = true;
                } else {
                    this.readBufferFileNum = firstNum;
                    this.readBufferFileEnd = 0L;
                }
            }
            this.nextEntryOffset = this.readBufferFileEnd;
        } else {
            if (!$assertionsDisabled && this.startLsn == -1L) {
                throw new AssertionError();
            }
            this.readBufferFileNum = DbLsn.getFileNumber(endOfFileLsn);
            this.readBufferFileEnd = this.readBufferFileStart = DbLsn.getFileOffset(endOfFileLsn);
            this.currentEntryPrevOffset = DbLsn.getFileNumber(this.startLsn) == DbLsn.getFileNumber(endOfFileLsn) ? DbLsn.getFileOffset(this.startLsn) : 0L;
            this.currentEntryOffset = DbLsn.getFileOffset(endOfFileLsn);
        }
    }

    public void setAlwaysValidateChecksum(boolean validate) {
        this.alwaysValidateChecksum = validate;
    }

    public int getNumRead() {
        return this.nRead;
    }

    public long getNRepeatIteratorReads() {
        return this.nRepeatIteratorReads;
    }

    public long getLastLsn() {
        return DbLsn.makeLsn(this.readBufferFileNum, this.currentEntryOffset);
    }

    public boolean readNextEntry() throws DatabaseException, IOException {
        boolean foundEntry = false;
        try {
            while (!this.eof && !foundEntry) {
                boolean collectData;
                this.getLogEntryInReadBuffer();
                ByteBuffer dataBuffer = this.readData(14, true);
                this.readHeader(dataBuffer);
                boolean isTargetEntry = this.isTargetEntry(this.currentEntryTypeNum, this.currentEntryTypeVersion);
                boolean doValidate = this.doValidateChecksum && (isTargetEntry || this.alwaysValidateChecksum);
                boolean bl = collectData = doValidate || isTargetEntry;
                if (doValidate) {
                    this.startChecksum(dataBuffer);
                }
                dataBuffer = this.readData(this.currentEntrySize, collectData);
                if (this.forward) {
                    this.currentEntryOffset = this.nextEntryOffset;
                    this.nextEntryOffset += (long)(14 + this.currentEntrySize);
                }
                if (doValidate) {
                    this.validateChecksum(dataBuffer);
                }
                if (isTargetEntry) {
                    if (!this.processEntry(dataBuffer)) continue;
                    foundEntry = true;
                    ++this.nRead;
                    continue;
                }
                if (!collectData) continue;
                this.threadSafeBufferPosition(dataBuffer, this.threadSafeBufferPosition(dataBuffer) + this.currentEntrySize);
            }
        }
        catch (EOFException e) {
            this.eof = true;
        }
        catch (DatabaseException e) {
            this.eof = true;
            LogEntryType problemType = LogEntryType.findType(this.currentEntryTypeNum, this.currentEntryTypeVersion);
            Tracer.trace(this.env, "FileReader", "readNextEntry", "Halted log file reading at file 0x" + Long.toHexString(this.readBufferFileNum) + " offset 0x" + Long.toHexString(this.nextEntryOffset) + " offset(decimal)=" + this.nextEntryOffset + ":\nentry=" + problemType + "(typeNum=" + this.currentEntryTypeNum + ",version=" + this.currentEntryTypeVersion + ")\nprev=0x" + Long.toHexString(this.currentEntryPrevOffset) + "\nsize=" + this.currentEntrySize + "\nNext entry should be at 0x" + Long.toHexString(this.nextEntryOffset + 14L + (long)this.currentEntrySize) + "\n:", e);
            throw e;
        }
        return foundEntry;
    }

    protected boolean resyncReader(long nextGoodRecordPostCorruption, boolean dumpCorruptedBounds) throws DatabaseException, IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLogEntryInReadBuffer() throws IOException, DatabaseException, EOFException {
        long nextLsn;
        if (!this.forward) {
            if (this.currentEntryPrevOffset != 0L && this.currentEntryPrevOffset >= this.readBufferFileStart) {
                long nextLsn2 = DbLsn.makeLsn(this.readBufferFileNum, this.currentEntryPrevOffset);
                if (this.finishLsn != -1L && DbLsn.compareTo(nextLsn2, this.finishLsn) == -1) {
                    throw new EOFException();
                }
                this.threadSafeBufferPosition(this.readBuffer, (int)(this.currentEntryPrevOffset - this.readBufferFileStart));
            } else {
                if (this.currentEntryPrevOffset == 0L) {
                    this.currentEntryPrevOffset = this.fileManager.getFileHeaderPrevOffset(this.readBufferFileNum);
                    Long prevFileNum = this.fileManager.getFollowingFileNum(this.readBufferFileNum, false);
                    if (prevFileNum == null) {
                        throw new EOFException();
                    }
                    if (this.readBufferFileNum - prevFileNum != 1L && !this.resyncReader(DbLsn.makeLsn(prevFileNum, 0xFFFFFFFFL), false)) {
                        throw new DatabaseException("Cannot read backward over cleaned file from " + this.readBufferFileNum + " to " + prevFileNum);
                    }
                    this.readBufferFileNum = prevFileNum;
                    this.readBufferFileStart = this.currentEntryPrevOffset;
                } else {
                    long newPosition;
                    this.readBufferFileStart = this.currentEntryOffset - this.currentEntryPrevOffset > (long)this.readBuffer.capacity() ? this.currentEntryPrevOffset : ((newPosition = this.currentEntryOffset - (long)this.readBuffer.capacity()) < 0L ? 0L : newPosition);
                }
                long nextLsn3 = DbLsn.makeLsn(this.readBufferFileNum, this.currentEntryPrevOffset);
                if (this.finishLsn != -1L && DbLsn.compareTo(nextLsn3, this.finishLsn) == -1) {
                    throw new EOFException();
                }
                FileHandle fileHandle = this.fileManager.getFileHandle(this.readBufferFileNum);
                try {
                    this.readBuffer.clear();
                    this.fileManager.readFromFile(fileHandle.getFile(), this.readBuffer, this.readBufferFileStart);
                    if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                        throw new AssertionError();
                    }
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    fileHandle.release();
                    throw throwable;
                }
                fileHandle.release();
                this.readBufferFileEnd = this.readBufferFileStart + (long)this.threadSafeBufferPosition(this.readBuffer);
                this.threadSafeBufferFlip(this.readBuffer);
                this.threadSafeBufferPosition(this.readBuffer, (int)(this.currentEntryPrevOffset - this.readBufferFileStart));
            }
            this.currentEntryOffset = this.currentEntryPrevOffset;
        } else if (this.finishLsn != -1L && DbLsn.compareTo(nextLsn = DbLsn.makeLsn(this.readBufferFileNum, this.nextEntryOffset), this.finishLsn) >= 0) {
            throw new EOFException();
        }
    }

    private void readHeader(ByteBuffer dataBuffer) throws DatabaseException {
        this.currentEntryChecksum = LogUtils.getUnsignedInt(dataBuffer);
        dataBuffer.mark();
        this.currentEntryTypeNum = dataBuffer.get();
        if (!LogEntryType.isValidType(this.currentEntryTypeNum)) {
            throw new DbChecksumException(this.anticipateChecksumErrors ? null : this.env, "FileReader read invalid log entry type: " + this.currentEntryTypeNum);
        }
        this.currentEntryTypeVersion = dataBuffer.get();
        this.currentEntryPrevOffset = LogUtils.getUnsignedInt(dataBuffer);
        this.currentEntrySize = LogUtils.readInt(dataBuffer);
    }

    private void startChecksum(ByteBuffer dataBuffer) throws DatabaseException {
        this.cksumValidator.reset();
        int entryStart = this.threadSafeBufferPosition(dataBuffer);
        dataBuffer.reset();
        this.cksumValidator.update(this.env, dataBuffer, 10, this.anticipateChecksumErrors);
        this.threadSafeBufferPosition(dataBuffer, entryStart);
    }

    private void validateChecksum(ByteBuffer entryBuffer) throws DatabaseException {
        this.cksumValidator.update(this.env, entryBuffer, this.currentEntrySize, this.anticipateChecksumErrors);
        this.cksumValidator.validate(this.env, this.currentEntryChecksum, this.readBufferFileNum, this.currentEntryOffset, this.anticipateChecksumErrors);
    }

    private ByteBuffer readData(int amountToRead, boolean collectData) throws IOException, DatabaseException, EOFException {
        int alreadyRead = 0;
        ByteBuffer completeBuffer = null;
        this.saveBuffer.clear();
        while (alreadyRead < amountToRead && !this.eof) {
            int bytesNeeded = amountToRead - alreadyRead;
            if (this.readBuffer.hasRemaining()) {
                if (collectData) {
                    if (alreadyRead > 0 || this.readBuffer.remaining() < bytesNeeded) {
                        this.copyToSaveBuffer(bytesNeeded);
                        alreadyRead = this.threadSafeBufferPosition(this.saveBuffer);
                        completeBuffer = this.saveBuffer;
                        continue;
                    }
                    completeBuffer = this.readBuffer;
                    alreadyRead = amountToRead;
                    continue;
                }
                int positionIncrement = this.readBuffer.remaining() > bytesNeeded ? bytesNeeded : this.readBuffer.remaining();
                alreadyRead += positionIncrement;
                this.threadSafeBufferPosition(this.readBuffer, this.threadSafeBufferPosition(this.readBuffer) + positionIncrement);
                completeBuffer = this.readBuffer;
                continue;
            }
            this.fillReadBuffer(bytesNeeded);
        }
        this.threadSafeBufferFlip(this.saveBuffer);
        return completeBuffer;
    }

    private void adjustReadBufferSize(int amountToRead) {
        int readBufferSize = this.readBuffer.capacity();
        if (amountToRead > readBufferSize) {
            if (readBufferSize < this.maxReadBufferSize) {
                if (amountToRead < this.maxReadBufferSize) {
                    readBufferSize = amountToRead;
                    int remainder = readBufferSize % 1024;
                    readBufferSize += 1024 - remainder;
                    readBufferSize = Math.min(readBufferSize, this.maxReadBufferSize);
                } else {
                    readBufferSize = this.maxReadBufferSize;
                }
                this.readBuffer = ByteBuffer.allocate(readBufferSize);
            }
            if (amountToRead > this.readBuffer.capacity()) {
                ++this.nRepeatIteratorReads;
            }
        }
    }

    private void copyToSaveBuffer(int bytesNeeded) {
        ByteBuffer temp;
        int bytesFromThisBuffer = bytesNeeded <= this.readBuffer.remaining() ? bytesNeeded : this.readBuffer.remaining();
        if (this.saveBuffer.capacity() - this.threadSafeBufferPosition(this.saveBuffer) < bytesFromThisBuffer) {
            temp = ByteBuffer.allocate(this.saveBuffer.capacity() + bytesFromThisBuffer);
            this.threadSafeBufferFlip(this.saveBuffer);
            temp.put(this.saveBuffer);
            this.saveBuffer = temp;
        }
        temp = this.readBuffer.slice();
        temp.limit(bytesFromThisBuffer);
        this.saveBuffer.put(temp);
        this.threadSafeBufferPosition(this.readBuffer, this.threadSafeBufferPosition(this.readBuffer) + bytesFromThisBuffer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillReadBuffer(int bytesNeeded) throws DatabaseException, EOFException {
        FileHandle fileHandle = null;
        try {
            try {
                Long nextFile;
                this.adjustReadBufferSize(bytesNeeded);
                fileHandle = this.fileManager.getFileHandle(this.readBufferFileNum);
                boolean fileOk = false;
                if (this.readBufferFileEnd < fileHandle.getFile().length()) {
                    fileOk = true;
                } else if (!this.singleFile && (nextFile = this.fileManager.getFollowingFileNum(this.readBufferFileNum, this.forward)) != null) {
                    this.readBufferFileNum = nextFile;
                    fileHandle.release();
                    fileHandle = this.fileManager.getFileHandle(this.readBufferFileNum);
                    fileOk = true;
                    this.readBufferFileEnd = 0L;
                    this.nextEntryOffset = 0L;
                }
                if (!fileOk) throw new EOFException();
                this.readBuffer.clear();
                this.fileManager.readFromFile(fileHandle.getFile(), this.readBuffer, this.readBufferFileEnd);
                if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                    throw new AssertionError();
                }
                this.readBufferFileStart = this.readBufferFileEnd;
                this.readBufferFileEnd = this.readBufferFileStart + (long)this.threadSafeBufferPosition(this.readBuffer);
                this.threadSafeBufferFlip(this.readBuffer);
                Object var6_6 = null;
                if (fileHandle == null) return;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new DatabaseException("Problem in fillReadBuffer, readBufferFileNum = " + this.readBufferFileNum + ": " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (fileHandle == null) throw throwable;
            fileHandle.release();
            throw throwable;
        }
        fileHandle.release();
    }

    protected boolean isTargetEntry(byte logEntryTypeNumber, byte logEntryTypeVersion) throws DatabaseException {
        return true;
    }

    protected abstract boolean processEntry(ByteBuffer var1) throws DatabaseException;

    private Buffer threadSafeBufferFlip(ByteBuffer buffer) {
        while (true) {
            try {
                return buffer.flip();
            }
            catch (IllegalArgumentException IAE) {
                continue;
            }
            break;
        }
    }

    private int threadSafeBufferPosition(ByteBuffer buffer) {
        while (true) {
            try {
                return buffer.position();
            }
            catch (IllegalArgumentException IAE) {
                continue;
            }
            break;
        }
    }

    private Buffer threadSafeBufferPosition(ByteBuffer buffer, int newPosition) {
        while (true) {
            try {
                return buffer.position(newPosition);
            }
            catch (IllegalArgumentException IAE) {
                continue;
            }
            break;
        }
    }

    static {
        $assertionsDisabled = !FileReader.class.desiredAssertionStatus();
    }

    private static class EOFException
    extends Exception {
        private EOFException() {
        }
    }
}

