/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseEntry;

public class ShortBinding
extends TupleBinding {
    private static final int SHORT_SIZE = 2;

    public Object entryToObject(TupleInput input) {
        return new Short(input.readShort());
    }

    public void objectToEntry(Object object, TupleOutput output) {
        output.writeShort(((Number)object).shortValue());
    }

    protected TupleOutput getTupleOutput(Object object) {
        return ShortBinding.sizedOutput();
    }

    public static short entryToShort(DatabaseEntry entry) {
        return ShortBinding.entryToInput(entry).readShort();
    }

    public static void shortToEntry(short val, DatabaseEntry entry) {
        ShortBinding.outputToEntry(ShortBinding.sizedOutput().writeShort(val), entry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[2]);
    }
}

