/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.ChannelListener;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;

public class RpcDispatcherShunTest
implements MembershipListener,
RequestHandler,
ChannelListener {
    JChannel channel;
    RpcDispatcher disp;

    public static void main(String[] args) {
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equals("-props")) {
                RpcDispatcherShunTest.help();
                return;
            }
            props = args[++i];
        }
        try {
            new RpcDispatcherShunTest().start(props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void start(String props) throws IOException, ChannelException {
        this.channel = new JChannel(props);
        this.channel.addChannelListener(this);
        this.channel.setOpt(5, Boolean.TRUE);
        this.disp = new RpcDispatcher((Channel)this.channel, null, (MembershipListener)this, (Object)this, false, true);
        this.channel.connect("MessageDispatcherTestGroup");
        this.mainLoop();
    }

    private void mainLoop() throws IOException {
        while (true) {
            System.in.skip(System.in.available());
            System.out.println("\n[1] Send [2] Shun [3] Print view [q] Quit");
            int c = System.in.read();
            switch (c) {
                case -1: {
                    break;
                }
                case 49: {
                    this.invokeGroupMethod();
                    break;
                }
                case 50: {
                    this.shun();
                    break;
                }
                case 51: {
                    View v = this.channel.getView();
                    System.out.println("View: " + v);
                    break;
                }
                case 113: {
                    this.channel.close();
                    return;
                }
            }
        }
    }

    public Object helloWorld() {
        System.out.println("method helloWorld() was called");
        return "same to you";
    }

    private void shun() {
        System.out.println("shunning this member");
        this.channel.up(new Event(46));
    }

    private void invokeGroupMethod() {
        View v = this.channel.getView();
        if (v == null) {
            return;
        }
        Vector<Address> members = new Vector<Address>(v.getMembers());
        System.out.println("sending to " + members);
        RspList rsp_list = this.disp.callRemoteMethods(members, "helloWorld", null, (String[])null, 2, 0L);
        System.out.println("responses:\n" + rsp_list);
    }

    private static void help() {
        System.out.println("MessageDispatcherShunTest [-help] [-props <props>]");
    }

    @Override
    public Object handle(Message msg) {
        return "same to you";
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("-- view: " + new_view);
    }

    @Override
    public void suspect(Address suspected_mbr) {
    }

    @Override
    public void block() {
    }

    @Override
    public void channelConnected(Channel channel) {
    }

    @Override
    public void channelDisconnected(Channel channel) {
    }

    @Override
    public void channelClosed(Channel channel) {
    }

    @Override
    public void channelShunned() {
    }

    @Override
    public void channelReconnected(Address addr) {
    }
}

