/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.protocols.DISCARD_PAYLOAD;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class NAKACK_OOB_Test
extends TestCase {
    JChannel ch1;
    JChannel ch2;
    JChannel ch3;
    final String props = "udp.xml";

    public NAKACK_OOB_Test(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.ch1 = new JChannel("udp.xml");
        this.ch2 = new JChannel("udp.xml");
        this.ch3 = new JChannel("udp.xml");
    }

    public void tearDown() throws Exception {
        if (this.ch1 != null) {
            this.ch1.close();
        }
        if (this.ch2 != null) {
            this.ch2.close();
        }
        if (this.ch3 != null) {
            this.ch3.close();
        }
        super.tearDown();
    }

    public void testOutOfBandMessages() throws Exception {
        MyReceiver receiver1 = new MyReceiver();
        MyReceiver receiver2 = new MyReceiver();
        MyReceiver receiver3 = new MyReceiver();
        this.ch1.setReceiver(receiver1);
        this.ch2.setReceiver(receiver2);
        this.ch3.setReceiver(receiver3);
        this.ch1.getProtocolStack().insertProtocol((Protocol)new DISCARD_PAYLOAD(), 2, "NAKACK");
        this.ch2.getProtocolStack().insertProtocol((Protocol)new DISCARD_PAYLOAD(), 2, "NAKACK");
        this.ch3.getProtocolStack().insertProtocol((Protocol)new DISCARD_PAYLOAD(), 2, "NAKACK");
        this.ch1.connect("x");
        this.ch2.connect("x");
        this.ch3.connect("x");
        NAKACK_OOB_Test.assertEquals((int)3, (int)this.ch3.getView().getMembers().size());
        for (int i = 1; i <= 5; ++i) {
            Message msg = new Message(null, null, new Long(i));
            if (i == 4) {
                msg.setFlag((byte)1);
            }
            System.out.println("-- sending message #" + i);
            this.ch1.send(msg);
            Util.sleep(100L);
        }
        Util.sleep(5000L);
        List seqnos1 = receiver1.getSeqnos();
        List seqnos2 = receiver2.getSeqnos();
        List seqnos3 = receiver3.getSeqnos();
        System.out.println("sequence numbers:");
        System.out.println("ch1: " + seqnos1);
        System.out.println("ch2: " + seqnos2);
        System.out.println("ch3: " + seqnos3);
        Long[] expected_seqnos = new Long[]{new Long(1L), new Long(2L), new Long(4L), new Long(3L), new Long(5L)};
        for (int i = 0; i < expected_seqnos.length; ++i) {
            Long expected_seqno = expected_seqnos[i];
            Long received_seqno = (Long)seqnos1.get(i);
            NAKACK_OOB_Test.assertEquals((Object)expected_seqno, (Object)received_seqno);
            received_seqno = (Long)seqnos2.get(i);
            NAKACK_OOB_Test.assertEquals((Object)expected_seqno, (Object)received_seqno);
            received_seqno = (Long)seqnos3.get(i);
            NAKACK_OOB_Test.assertEquals((Object)expected_seqno, (Object)received_seqno);
        }
    }

    public static Test suite() {
        return new TestSuite(NAKACK_OOB_Test.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)NAKACK_OOB_Test.suite());
    }

    public static class MyReceiver
    extends ReceiverAdapter {
        List seqnos = new LinkedList();

        public List getSeqnos() {
            return this.seqnos;
        }

        @Override
        public void receive(Message msg) {
            if (msg != null) {
                Long num = (Long)msg.getObject();
                this.seqnos.add(num);
            }
        }
    }
}

