/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jgroups.Channel;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class ConcurrentFlushTest
extends ChannelTestBase {
    JChannel c1;
    JChannel c2;
    JChannel c3;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        CHANNEL_CONFIG = System.getProperty("channel.conf.flush", "flush-udp.xml");
    }

    @Override
    public void tearDown() throws Exception {
        if (this.c3 != null) {
            this.c3.close();
            ConcurrentFlushTest.assertFalse((boolean)this.c3.isOpen());
            ConcurrentFlushTest.assertFalse((boolean)this.c3.isConnected());
            this.c3 = null;
        }
        if (this.c2 != null) {
            this.c2.close();
            ConcurrentFlushTest.assertFalse((boolean)this.c2.isOpen());
            ConcurrentFlushTest.assertFalse((boolean)this.c2.isConnected());
            this.c2 = null;
        }
        if (this.c1 != null) {
            this.c1.close();
            ConcurrentFlushTest.assertFalse((boolean)this.c1.isOpen());
            ConcurrentFlushTest.assertFalse((boolean)this.c1.isConnected());
            this.c1 = null;
        }
        Util.sleep(500L);
        super.tearDown();
    }

    @Override
    public boolean useBlocking() {
        return true;
    }

    public void testTwoStartFlushesOnSameMemberWithTotalFlush() throws Exception {
        this.c1 = this.createChannel();
        this.c1.connect("testTwoStartFlushes");
        this.c2 = this.createChannel();
        this.c2.connect("testTwoStartFlushes");
        ConcurrentFlushTest.assertViewsReceived(this.c1, this.c2);
        ConcurrentFlushTest.startFlush(this.c1, false);
        new Thread(){

            @Override
            public void run() {
                ConcurrentFlushTest.stopFlush(ConcurrentFlushTest.this.c1);
            }
        }.start();
        boolean rc = ConcurrentFlushTest.startFlush(this.c1, false);
        assert (rc);
        ConcurrentFlushTest.stopFlush(this.c1);
        rc = ConcurrentFlushTest.startFlush(this.c1, false);
        assert (rc);
        ConcurrentFlushTest.stopFlush(this.c1);
        rc = ConcurrentFlushTest.startFlush(this.c1, true);
        assert (rc);
        rc = ConcurrentFlushTest.startFlush(this.c1, true);
        rc = ConcurrentFlushTest.startFlush(this.c2, true);
    }

    public void testTwoStartFlushesOnDifferentMembersWithTotalFlush() throws Exception {
        this.c1 = this.createChannel();
        this.c1.connect("testTwoStartFlushesOnDifferentMembersWithTotalFlush");
        this.c2 = this.createChannel();
        this.c2.connect("testTwoStartFlushesOnDifferentMembersWithTotalFlush");
        ConcurrentFlushTest.assertViewsReceived(this.c1, this.c2);
        boolean rc = ConcurrentFlushTest.startFlush(this.c1, false);
        assert (rc);
        rc = ConcurrentFlushTest.startFlush(this.c2, false);
        assert (!rc);
        new Thread(){

            @Override
            public void run() {
                ConcurrentFlushTest.stopFlush(ConcurrentFlushTest.this.c1);
            }
        }.start();
        rc = ConcurrentFlushTest.startFlush(this.c2, false);
        assert (rc);
        ConcurrentFlushTest.stopFlush(this.c2);
        rc = ConcurrentFlushTest.startFlush(this.c1, false);
        assert (rc);
        ConcurrentFlushTest.stopFlush(this.c1);
        rc = ConcurrentFlushTest.startFlush(this.c2, true);
        assert (rc);
        rc = ConcurrentFlushTest.startFlush(this.c1, true);
        rc = ConcurrentFlushTest.startFlush(this.c2, true);
    }

    public void testConcurrentFlush() throws Exception {
        this.c1 = this.createChannel();
        this.c1.connect("testConcurrentFlush");
        this.c2 = this.createChannel();
        this.c2.connect("testConcurrentFlush");
        ConcurrentFlushTest.assertViewsReceived(this.c1, this.c2);
        final CountDownLatch startFlushLatch = new CountDownLatch(1);
        final CountDownLatch stopFlushLatch = new CountDownLatch(1);
        CountDownLatch flushStartReceived = new CountDownLatch(2);
        CountDownLatch flushStopReceived = new CountDownLatch(2);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    startFlushLatch.await();
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                Util.startFlush(ConcurrentFlushTest.this.c1);
                try {
                    stopFlushLatch.await();
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                ConcurrentFlushTest.this.c1.stopFlush();
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                try {
                    startFlushLatch.await();
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                Util.startFlush(ConcurrentFlushTest.this.c2);
                try {
                    stopFlushLatch.await();
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                ConcurrentFlushTest.this.c2.stopFlush();
            }
        };
        Listener l1 = new Listener(this.c1, flushStartReceived, flushStopReceived);
        Listener l2 = new Listener(this.c2, flushStartReceived, flushStopReceived);
        t1.start();
        t2.start();
        startFlushLatch.countDown();
        ConcurrentFlushTest.assertTrue((boolean)flushStartReceived.await(60L, TimeUnit.SECONDS));
        stopFlushLatch.countDown();
        ConcurrentFlushTest.assertTrue((boolean)flushStopReceived.await(60L, TimeUnit.SECONDS));
        assert (l1.blockReceived);
        assert (l1.unblockReceived);
        assert (l2.blockReceived);
        assert (l2.unblockReceived);
    }

    public void testConcurrentFlushAndPartialFlush() throws Exception {
        this.c1 = this.createChannel();
        this.c1.connect("testConcurrentFlushAndPartialFlush");
        this.c2 = this.createChannel();
        this.c2.connect("testConcurrentFlushAndPartialFlush");
        this.c3 = this.createChannel();
        this.c3.connect("testConcurrentFlushAndPartialFlush");
        ConcurrentFlushTest.assertViewsReceived(this.c1, this.c2, this.c3);
        final CountDownLatch startFlushLatch = new CountDownLatch(1);
        final CountDownLatch stopFlushLatch = new CountDownLatch(1);
        CountDownLatch flushStartReceived = new CountDownLatch(2);
        CountDownLatch flushStopReceived = new CountDownLatch(5);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    startFlushLatch.await();
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                Util.startFlush(ConcurrentFlushTest.this.c1);
                try {
                    stopFlushLatch.await();
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                ConcurrentFlushTest.this.c1.stopFlush();
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                try {
                    startFlushLatch.await();
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                Util.startFlush(ConcurrentFlushTest.this.c2, Arrays.asList(ConcurrentFlushTest.this.c2.getLocalAddress(), ConcurrentFlushTest.this.c3.getLocalAddress()));
                try {
                    stopFlushLatch.await();
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                ConcurrentFlushTest.this.c2.stopFlush(Arrays.asList(ConcurrentFlushTest.this.c2.getLocalAddress(), ConcurrentFlushTest.this.c3.getLocalAddress()));
            }
        };
        Listener l1 = new Listener(this.c1, flushStartReceived, flushStopReceived);
        Listener l2 = new Listener(this.c2, flushStartReceived, flushStopReceived);
        Listener l3 = new Listener(this.c3, flushStartReceived, flushStopReceived);
        t1.start();
        t2.start();
        startFlushLatch.countDown();
        ConcurrentFlushTest.assertTrue((boolean)flushStartReceived.await(60L, TimeUnit.SECONDS));
        stopFlushLatch.countDown();
        ConcurrentFlushTest.assertTrue((boolean)flushStopReceived.await(60L, TimeUnit.SECONDS));
        ConcurrentFlushTest.assertTrue((boolean)l1.blockReceived);
        ConcurrentFlushTest.assertTrue((boolean)l1.unblockReceived);
        ConcurrentFlushTest.assertTrue((boolean)l2.blockReceived);
        ConcurrentFlushTest.assertTrue((boolean)l2.unblockReceived);
        ConcurrentFlushTest.assertTrue((boolean)l3.blockReceived);
        ConcurrentFlushTest.assertTrue((boolean)l3.unblockReceived);
    }

    private static boolean startFlush(Channel ch, boolean automatic_resume) {
        System.out.println("starting flush on " + ch.getLocalAddress() + " with automatic resume=" + automatic_resume);
        boolean result = Util.startFlush(ch);
        if (automatic_resume) {
            ch.stopFlush();
        }
        return result;
    }

    private static void stopFlush(Channel ch) {
        System.out.println("calling stopFlush()");
        ch.stopFlush();
    }

    private static void assertViewsReceived(JChannel ... channels) {
        for (JChannel c : channels) {
            ConcurrentFlushTest.assertEquals((int)c.getView().getMembers().size(), (int)channels.length);
        }
    }

    private static class Listener
    extends ExtendedReceiverAdapter {
        boolean blockReceived;
        boolean unblockReceived;
        JChannel channel;
        CountDownLatch flushStartReceived;
        CountDownLatch flushStopReceived;

        Listener(JChannel channel, CountDownLatch flushStartReceived, CountDownLatch flushStopReceived) {
            this.channel = channel;
            this.flushStartReceived = flushStartReceived;
            this.flushStopReceived = flushStopReceived;
            this.channel.setReceiver(this);
        }

        @Override
        public void unblock() {
            this.unblockReceived = true;
            this.flushStopReceived.countDown();
        }

        @Override
        public void block() {
            this.blockReceived = true;
            this.flushStartReceived.countDown();
        }
    }
}

