/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingHeader;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class FILE_PING
extends Discovery {
    protected static final String name = "FILE_PING";
    protected static final String SUFFIX = ".node";
    protected String location = File.separator + "tmp" + File.separator + "jgroups";
    protected long interval = 60000L;
    protected File root_dir = null;
    protected FilenameFilter filter;
    private ScheduledFuture<?> writer_future;

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean setProperties(Properties props) {
        String str = props.getProperty("location");
        if (str != null) {
            this.location = str;
            props.remove("location");
        }
        if ((str = props.getProperty("interval")) != null) {
            this.interval = Long.parseLong(str);
            props.remove("interval");
        }
        return super.setProperties(props);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.createRootDir();
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.interval > 0L) {
            this.writer_future = this.timer.scheduleWithFixedDelay(new WriterTask(), this.interval, this.interval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        if (this.writer_future != null) {
            this.writer_future.cancel(false);
            this.writer_future = null;
        }
        super.stop();
    }

    @Override
    public void sendGetMembersRequest(Promise promise) throws Exception {
        String cluster_name = this.group_addr;
        List<Address> existing_mbrs = this.readAll(cluster_name);
        if (existing_mbrs.isEmpty() || existing_mbrs.size() == 1 && existing_mbrs.contains(this.local_addr)) {
            if (promise != null) {
                promise.setResult(null);
            }
        } else {
            for (final Address dest : existing_mbrs) {
                if (dest.equals(this.local_addr)) continue;
                PingHeader hdr = new PingHeader(1, null);
                final Message msg = new Message(dest);
                msg.setFlag((byte)1);
                msg.putHeader(this.getName(), hdr);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest()));
                }
                this.timer.execute(new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                FILE_PING.this.down_prot.down(new Event(1, msg));
                            }
                            catch (Exception ex) {
                                if (!FILE_PING.this.log.isErrorEnabled()) break block2;
                                FILE_PING.this.log.error((Object)("failed sending discovery request to " + dest), (Throwable)ex);
                            }
                        }
                    }
                });
            }
        }
        this.writeToFile(this.local_addr, cluster_name);
    }

    @Override
    public Object down(Event evt) {
        Object retval = super.down(evt);
        if (evt.getType() == 6) {
            this.handleView((View)evt.getArg());
        }
        return retval;
    }

    protected void createRootDir() {
        this.root_dir = new File(this.location);
        if (this.root_dir.exists()) {
            if (!this.root_dir.isDirectory()) {
                throw new IllegalArgumentException("location " + this.root_dir.getPath() + " is not a directory");
            }
        } else {
            this.root_dir.mkdirs();
        }
        if (!this.root_dir.exists()) {
            throw new IllegalArgumentException("location " + this.root_dir.getPath() + " could not be accessed");
        }
        this.filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(FILE_PING.SUFFIX);
            }
        };
    }

    protected void handleView(View view) {
        boolean is_coordinator;
        Vector<Address> mbrs = view.getMembers();
        boolean bl = is_coordinator = !mbrs.isEmpty() && ((Address)mbrs.iterator().next()).equals(this.local_addr);
        if (is_coordinator) {
            List<Address> addrs = this.readAll(this.group_addr);
            for (Address addr : addrs) {
                if (addr == null || mbrs.contains(addr)) continue;
                this.remove(this.group_addr, addr);
            }
        }
    }

    protected void remove(String clustername, Address addr) {
        if (clustername == null || addr == null) {
            return;
        }
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            return;
        }
        try {
            File file = new File(dir, addr.toString() + SUFFIX);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("removing " + file));
            }
            file.delete();
        }
        catch (Throwable e) {
            this.log.error((Object)"failure removing data", e);
        }
    }

    protected List<Address> readAll(String clustername) {
        File[] files;
        ArrayList<Address> retval = new ArrayList<Address>();
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if ((files = dir.listFiles(this.filter)) != null) {
            for (File file : files) {
                retval.add(FILE_PING.readFile(file));
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    protected static Address readFile(File file) {
        Address address;
        Address retval = null;
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(file));
            address = Util.readAddress(in);
        }
        catch (Exception exception) {
            Util.close(in);
            catch (Throwable throwable) {
                Util.close(in);
                throw throwable;
            }
        }
        Util.close(in);
        return address;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void writeToFile(Address addr, String clustername) {
        DataOutputStream out = null;
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            dir.mkdir();
        }
        File file = new File(dir, addr.toString() + SUFFIX);
        file.deleteOnExit();
        try {
            out = new DataOutputStream(new FileOutputStream(file));
            Util.writeAddress(addr, out);
        }
        catch (Exception e) {
            Util.close(out);
            catch (Throwable throwable) {
                Util.close(out);
                throw throwable;
            }
        }
        Util.close(out);
    }

    protected class WriterTask
    implements Runnable {
        protected WriterTask() {
        }

        @Override
        public void run() {
            FILE_PING.this.writeToFile(FILE_PING.this.local_addr, FILE_PING.this.group_addr);
        }
    }
}

