/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RpcDispatcherAnycastTest;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcherInterruptTest
extends ChannelTestBase {
    RpcDispatcher disp;
    RpcDispatcher disp2;
    Channel ch;
    Channel ch2;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ch = this.createChannel("A");
        ServerObject obj = new ServerObject();
        this.disp = new RpcDispatcher(this.ch, null, null, obj);
        this.ch.connect("demo");
        this.ch2 = this.createChannel("A");
        ServerObject obj2 = new ServerObject();
        this.disp2 = new RpcDispatcher(this.ch2, null, null, obj2);
        this.ch2.connect("demo");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.ch2.close();
        this.disp2.stop();
        this.ch.close();
        this.disp.stop();
    }

    public void testMethodCallWithTimeoutNoInterrupt() {
        long timeout = 0L;
        long block_time = 0L;
        RspList rsps = this.call(timeout, block_time);
        this.checkResults(rsps, 2, true);
        timeout = 0L;
        block_time = 1000L;
        rsps = this.call(timeout, block_time);
        this.checkResults(rsps, 2, true);
        timeout = 1000L;
        block_time = 0L;
        rsps = this.call(timeout, block_time);
        this.checkResults(rsps, 2, true);
        timeout = 1000L;
        block_time = 10000L;
        rsps = this.call(timeout, block_time);
        this.checkResults(rsps, 2, false);
    }

    private RspList call(long timeout, long block_time) {
        System.out.println("calling with timeout=" + timeout + ", block_time=" + block_time);
        long start = System.currentTimeMillis();
        RspList retval = this.disp.callRemoteMethods(null, "foo", new Object[]{block_time}, new Class[]{Long.TYPE}, 2, timeout);
        long stop = System.currentTimeMillis();
        long diff = stop - start;
        System.out.println("rsps (in " + diff + "ms:)\n" + retval);
        return retval;
    }

    private void checkResults(RspList rsps, int num, boolean received) {
        RpcDispatcherInterruptTest.assertEquals((String)("responses: " + rsps), (int)num, (int)rsps.size());
        for (Map.Entry<Address, Rsp> entry : rsps.entrySet()) {
            Rsp rsp = entry.getValue();
            RpcDispatcherInterruptTest.assertEquals((String)("rsp: " + rsp), (boolean)rsp.wasReceived(), (boolean)received);
        }
    }

    public static Test suite() {
        return new TestSuite(RpcDispatcherAnycastTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RpcDispatcherAnycastTest.suite());
    }

    static class ServerObject {
        ServerObject() {
        }

        public void foo(long timeout) {
            System.out.println("-- received foo(), blocking for " + timeout + " ms");
            Util.sleep(timeout);
            System.out.println("-- returning");
        }
    }
}

