/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.util.Arrays;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.JndiUtil;
import org.jboss.injection.AbstractPropertyInjector;
import org.jboss.injection.PojoInjector;
import org.jboss.injection.lang.reflect.BeanProperty;
import org.jboss.logging.Logger;

public class JndiPropertyInjector
extends AbstractPropertyInjector
implements PojoInjector {
    private static final Logger log = Logger.getLogger(JndiPropertyInjector.class);
    private String jndiName;
    private Context ctx;

    public JndiPropertyInjector(BeanProperty property, String jndiName, Context ctx) {
        super(property);
        this.jndiName = jndiName;
        this.ctx = ctx;
    }

    @Override
    public void inject(BeanContext bctx) {
        this.inject(bctx, bctx.getInstance());
    }

    @Override
    public Class<?> getInjectionClass() {
        return this.property.getType();
    }

    protected Object lookup(String jndiName) {
        Object dependency = null;
        try {
            dependency = JndiUtil.lookup(this.ctx, jndiName);
        }
        catch (NamingException e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            throw new RuntimeException("Unable to inject jndi dependency: " + jndiName + " into property " + this.property + ": " + cause.getMessage(), e);
        }
        return dependency;
    }

    @Override
    public void inject(BeanContext bctx, Object instance) {
        this.inject(instance);
    }

    @Override
    public void inject(Object instance) {
        Object value = this.lookup(this.jndiName);
        if (log.isTraceEnabled()) {
            log.trace((Object)("injecting " + value + " from " + this.jndiName + " into " + this.property + " of " + instance));
        }
        try {
            this.property.set(instance, value);
        }
        catch (IllegalArgumentException e) {
            String realJndiName;
            try {
                Object link = JndiUtil.lookupLink(this.ctx, this.jndiName);
                realJndiName = this.jndiName + (link instanceof LinkRef ? " (link -> " + ((LinkRef)link).getLinkName() + ")" : "");
            }
            catch (NamingException ne) {
                log.trace((Object)"Failed to obtain the real JNDI name", (Throwable)ne);
                realJndiName = this.jndiName;
            }
            Object[] interfaces = value.getClass().getInterfaces();
            String interfacesStr = interfaces.length > 0 ? " (implements " + Arrays.toString(interfaces) + ")" : "";
            String msg = "failed to inject " + value + interfacesStr + " from " + realJndiName + " into " + this.property + " of " + instance;
            throw new IllegalArgumentException(msg, e);
        }
    }
}

