/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import xjavadoc.filesystem.AbstractFile;

public class XJavadocFile
implements AbstractFile {
    private File file;

    public XJavadocFile(File file) {
        this.file = file;
    }

    @Override
    public Reader getReader() throws IOException {
        return new FileReader(this.file);
    }

    @Override
    public Reader getReader(String enc) throws UnsupportedEncodingException, FileNotFoundException {
        if (enc != null) {
            return new InputStreamReader((InputStream)new FileInputStream(this.file), enc);
        }
        return new InputStreamReader(new FileInputStream(this.file));
    }

    @Override
    public Writer getWriter() throws IOException {
        return new FileWriter(this.file);
    }

    @Override
    public boolean isWriteable() {
        return this.file.canWrite();
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this.file);
    }

    @Override
    public String getPath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    public String toString() {
        return "File " + this.file.getAbsolutePath();
    }
}

