/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.concurrent;

import java.util.concurrent.locks.ReentrantLock;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.concurrent.LockAcquisitionFailureException;
import org.jboss.aspects.concurrent.MutexLocked;
import org.jboss.aspects.concurrent.MutexedObject;

public class MutexAspect {

    public static class TimeoutMutex {
        protected MutexLocked props;

        public TimeoutMutex(MutexLocked props) {
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object acquire(Invocation invocation) throws Throwable {
            MutexedObject obj = (MutexedObject)invocation.getTargetObject();
            ReentrantLock lock = obj.getMutex();
            try {
                if (!lock.tryLock(this.props.timeout(), this.props.unit())) {
                    throw new LockAcquisitionFailureException("Failed to acquire permit for @Semaphored class.  Timeout reached.");
                }
            }
            catch (InterruptedException e) {
                throw new LockAcquisitionFailureException("Failed to acquire permit for @Semaphored class", e);
            }
            try {
                Object object = invocation.invokeNext();
                return object;
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static class TryLockMutex {
        protected MutexLocked props;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object acquire(Invocation invocation) throws Throwable {
            MutexedObject obj = (MutexedObject)invocation.getTargetObject();
            ReentrantLock lock = obj.getMutex();
            if (!lock.tryLock()) {
                throw new LockAcquisitionFailureException("Failed to lock for @Mutexed class");
            }
            try {
                Object object = invocation.invokeNext();
                return object;
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static class BlockingMutex {
        protected MutexLocked props;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object acquire(Invocation invocation) throws Throwable {
            MutexedObject obj = (MutexedObject)invocation.getTargetObject();
            ReentrantLock lock = obj.getMutex();
            try {
                lock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new LockAcquisitionFailureException("Failed to lock for @Mutexed class", e);
            }
            try {
                Object object = invocation.invokeNext();
                return object;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

