/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.layout;

import java.io.File;
import java.util.Hashtable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.MavenJPackageDepmap;

public class JPackageRepositoryLayout
implements ArtifactRepositoryLayout {
    private static Hashtable jppArtifactMap;
    private static final char GROUP_SEPARATOR = '.';
    private static final char PATH_SEPARATOR = '/';

    public String pathOf(Artifact artifact) {
        ArtifactHandler artifactHandler = artifact.getArtifactHandler();
        StringBuffer path = new StringBuffer();
        String artifactId = artifact.getArtifactId();
        String groupId = artifact.getGroupId();
        String version = artifact.getVersion();
        if (!groupId.startsWith("JPP")) {
            MavenJPackageDepmap map = MavenJPackageDepmap.getInstance();
            Hashtable newInfo = map.getMappedInfo(groupId, artifactId, version);
            groupId = (String)newInfo.get("group");
            artifactId = (String)newInfo.get("artifact");
        }
        if (groupId.startsWith("JPP")) {
            if (artifactHandler.getPackaging().equals("pom")) {
                path = this.getPOMPath(groupId, artifactId);
            } else {
                path.append(groupId).append('/');
                path.append(artifactId).append("." + artifactHandler.getExtension());
            }
        } else {
            path.append(groupId.replace('.', '/')).append('/').append(artifactId).append('/').append(version).append('/');
            path.append(artifactId).append('-').append(version).append(".");
            if (artifactHandler.getPackaging().equals("xml")) {
                path.append("pom");
            } else {
                path.append(artifactHandler.getPackaging());
            }
        }
        return path.toString();
    }

    private StringBuffer getPOMPath(String groupId, String artifactId) {
        StringBuffer path = new StringBuffer();
        String fName = groupId.replace('/', '.') + "-" + artifactId + ".pom";
        path.append(System.getProperty("maven2.jpp.pom.path", "JPP/maven2/poms")).append("/").append(fName);
        File f = new File(System.getProperty("maven2.jpp.default.repo", "/usr/share/maven2/repository") + "/" + path.toString());
        System.err.println("Checking path " + f.getAbsolutePath() + " for the pom");
        if (!f.exists()) {
            System.err.println(f.getAbsolutePath() + " not found");
            path = new StringBuffer();
            path.append(System.getProperty("maven2.jpp.default.pom.path", "JPP/maven2/default_poms")).append("/").append(fName);
        }
        return path;
    }

    public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
        return this.pathOfRepositoryMetadata(metadata, metadata.getLocalFilename(repository));
    }

    private String pathOfRepositoryMetadata(ArtifactMetadata metadata, String filename) {
        StringBuffer path = new StringBuffer();
        if (filename.substring(filename.length() - 4).equals(".pom")) {
            path = this.getPOMPath(metadata.getGroupId(), metadata.getArtifactId());
        } else {
            path.append(System.getProperty("maven2.jpp.pom.path", "maven2/poms")).append("/").append(filename);
        }
        return path.toString();
    }

    public String pathOfRemoteRepositoryMetadata(ArtifactMetadata metadata) {
        return this.pathOfRepositoryMetadata(metadata, metadata.getRemoteFilename());
    }
}

