/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.pseudoserver;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

class RecordingOutputStream
extends OutputStream {
    private OutputStream _nestedStream;
    private PrintStream _log;

    public RecordingOutputStream(OutputStream nestedStream, PrintStream log) {
        this._nestedStream = nestedStream;
        this._log = log;
    }

    @Override
    public void write(int b) throws IOException {
        this._nestedStream.write(b);
        this._log.println("sending " + Integer.toHexString(b));
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        this._nestedStream.write(b, offset, len);
        this._log.print("sending");
        for (int i = offset; i < offset + len; ++i) {
            this._log.print(' ' + Integer.toHexString(b[i]));
        }
        this._log.println();
    }
}

