/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.DefaultWebResponse;
import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.NoSuchFrameException;
import com.meterware.httpunit.RequestContext;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebWindow;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.xml.sax.SAXException;

class FrameHolder {
    private Hashtable _contents = new Hashtable();
    private Hashtable _subframes = new Hashtable();
    private WebWindow _window;
    private FrameSelector _topFrame;

    FrameHolder(WebWindow window) {
        this._window = window;
        this._topFrame = FrameSelector.newTopFrame(window);
        DefaultWebResponse blankResponse = new DefaultWebResponse(window.getClient(), null, "");
        this._contents.put(this._topFrame, blankResponse);
        HttpUnitOptions.getScriptingEngine().associate(blankResponse);
    }

    FrameSelector getTopFrame() {
        return this._topFrame;
    }

    WebResponse getFrameContents(FrameSelector targetFrame) {
        WebResponse response;
        if (targetFrame == FrameSelector.TOP_FRAME) {
            targetFrame = this.getTopFrame();
        }
        if ((response = this.get(targetFrame)) == null) {
            throw new NoSuchFrameException(targetFrame.getName());
        }
        return response;
    }

    WebResponse getSubframeContents(FrameSelector frame, String subFrameName) {
        FrameSelector[] subframes = (FrameSelector[])this._subframes.get(frame);
        if (subframes == null) {
            throw new NoSuchFrameException(subFrameName);
        }
        for (int i = 0; i < subframes.length; ++i) {
            FrameSelector subframe = subframes[i];
            if (!subframe.getName().equalsIgnoreCase(subFrameName)) continue;
            return this.get(subframe);
        }
        throw new NoSuchFrameException(subFrameName);
    }

    WebResponse getParentFrameContents(FrameSelector frame) {
        return this.get(frame.getParent() == null ? this._topFrame : frame.getParent());
    }

    WebResponse get(FrameSelector targetFrame) {
        return (WebResponse)this._contents.get(targetFrame);
    }

    WebResponse get(String target) {
        FrameSelector frame = this.getFrame(this._topFrame, target);
        return frame == null ? null : (WebResponse)this._contents.get(frame);
    }

    FrameSelector getFrame(String target) {
        return target.equals(this._window.getName()) ? this._topFrame : this.getFrame(this._topFrame, target);
    }

    private FrameSelector getFrame(FrameSelector rootFrame, String target) {
        if (target.equalsIgnoreCase("_top")) {
            return this._topFrame;
        }
        if (target.equalsIgnoreCase(rootFrame.getName())) {
            return rootFrame;
        }
        return this.lookupFrame(rootFrame, target);
    }

    private FrameSelector lookupFrame(FrameSelector rootFrame, String target) {
        FrameSelector result = this.getFromSubframe(rootFrame, target);
        if (result != null) {
            return result;
        }
        if (rootFrame.getName().equals(target)) {
            return rootFrame;
        }
        if (rootFrame.getParent() != null) {
            return this.lookupFrame(rootFrame.getParent(), target);
        }
        return null;
    }

    private FrameSelector getFromSubframe(FrameSelector rootFrame, String target) {
        int i;
        FrameSelector[] subframes = (FrameSelector[])this._subframes.get(rootFrame);
        if (subframes == null) {
            return null;
        }
        for (i = 0; i < subframes.length; ++i) {
            if (!subframes[i].getName().equalsIgnoreCase(target)) continue;
            return subframes[i];
        }
        for (i = 0; i < subframes.length; ++i) {
            FrameSelector result = this.getFromSubframe(subframes[i], target);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    List getActiveFrameNames() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration e = this._contents.keys();
        while (e.hasMoreElements()) {
            result.add(((FrameSelector)e.nextElement()).getName());
        }
        return result;
    }

    FrameSelector getTargetFrame(WebRequest request) {
        if ("_blank".equalsIgnoreCase(request.getTarget())) {
            return FrameSelector.NEW_FRAME;
        }
        if ("_top".equalsIgnoreCase(request.getTarget())) {
            return this._topFrame;
        }
        if ("_self".equalsIgnoreCase(request.getTarget())) {
            return request.getSourceFrame();
        }
        if ("_parent".equalsIgnoreCase(request.getTarget())) {
            return request.getSourceFrame().getParent();
        }
        if (request.getSourceFrame().getName().equalsIgnoreCase(request.getTarget())) {
            return request.getSourceFrame();
        }
        FrameSelector targetFrame = this.getFrame(request.getSourceFrame(), request.getTarget());
        if (targetFrame == null) {
            targetFrame = this._window.getClient().findFrame(request.getTarget());
        }
        return targetFrame != null ? targetFrame : FrameSelector.NEW_FRAME;
    }

    void updateFrames(WebResponse response, FrameSelector frame, RequestContext requestContext) throws MalformedURLException, IOException, SAXException {
        this.removeSubFrames(frame);
        this._contents.put(frame, response);
        if (response.isHTML()) {
            if (!response.hasSubframes()) {
                requestContext.addNewResponse(response);
            } else {
                HttpUnitOptions.getScriptingEngine().associate(response);
                this.createSubFrames(frame, response.getFrameSelectors());
                WebRequest[] requests = response.getFrameRequests();
                for (int i = 0; i < requests.length; ++i) {
                    if (requests[i].getURLString().length() == 0) continue;
                    response.getWindow().getSubframeResponse(requests[i], requestContext);
                }
                HttpUnitOptions.getScriptingEngine().load(response);
            }
        }
    }

    private void removeSubFrames(FrameSelector frame) {
        FrameSelector[] subframes = (FrameSelector[])this._subframes.get(frame);
        if (subframes == null) {
            return;
        }
        this._subframes.remove(frame);
        for (int i = 0; i < subframes.length; ++i) {
            this.removeSubFrames(subframes[i]);
            this._contents.remove(subframes[i]);
        }
    }

    private void createSubFrames(FrameSelector frame, FrameSelector[] subframes) {
        this._subframes.put(frame, subframes);
        for (int i = 0; i < subframes.length; ++i) {
            this._contents.put(subframes[i], WebResponse.createBlankResponse());
        }
    }

    static FrameSelector newNestedFrame(FrameSelector parentFrame, String relativeName) {
        if (relativeName == null || relativeName.length() == 0) {
            return new FrameSelector();
        }
        return new FrameSelector(relativeName, parentFrame);
    }
}

