/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.BooleanFormControl;
import com.meterware.httpunit.WebForm;
import java.util.List;
import org.w3c.dom.Node;

class CheckboxFormControl
extends BooleanFormControl {
    @Override
    public String getType() {
        return "checkbox";
    }

    public CheckboxFormControl(WebForm form, Node node) {
        super(form, node);
    }

    @Override
    void claimUniqueValue(List values) {
        boolean wasChecked = this.isChecked();
        if (this.isValueRequired()) {
            return;
        }
        this.setChecked(values.contains(this.getQueryValue()));
        if (this.isChecked()) {
            values.remove(this.getQueryValue());
        }
        if (this.isChecked() != wasChecked) {
            this.sendOnClickEvent();
        }
    }

    @Override
    String getQueryValue() {
        String value = this.getValueAttribute();
        return value.length() == 0 ? "on" : value;
    }

    @Override
    public void toggle() {
        this.setChecked(!this.isChecked());
    }

    @Override
    public void setState(boolean state) {
        this.setChecked(state);
    }
}

