/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class IdentityMap
implements Map {
    private final Map map;
    private transient Map.Entry[] entryArray = new Map.Entry[0];
    private transient boolean dirty = false;

    public static Map instantiate(int size) {
        return new IdentityMap(new HashMap(size));
    }

    public static Map instantiateSequenced(int size) {
        return new IdentityMap(new LinkedHashMap(size));
    }

    private IdentityMap(Map underlyingMap) {
        this.map = underlyingMap;
        this.dirty = true;
    }

    public static Map.Entry[] concurrentEntries(Map map) {
        return ((IdentityMap)map).entryArray();
    }

    public static List entries(Map map) {
        return ((IdentityMap)map).entryList();
    }

    public static Iterator keyIterator(Map map) {
        return ((IdentityMap)map).keyIterator();
    }

    public Iterator keyIterator() {
        return new KeyIterator(this.map.keySet().iterator());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        IdentityKey k = new IdentityKey(key);
        return this.map.containsKey(k);
    }

    @Override
    public boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    public Object get(Object key) {
        IdentityKey k = new IdentityKey(key);
        return this.map.get(k);
    }

    public Object put(Object key, Object value) {
        this.dirty = true;
        return this.map.put(new IdentityKey(key), value);
    }

    public Object remove(Object key) {
        this.dirty = true;
        IdentityKey k = new IdentityKey(key);
        return this.map.remove(k);
    }

    public void putAll(Map otherMap) {
        for (Map.Entry me : otherMap.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public void clear() {
        this.dirty = true;
        this.entryArray = null;
        this.map.clear();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        HashSet<IdentityMapEntry> set = new HashSet<IdentityMapEntry>(this.map.size());
        for (Map.Entry me : this.map.entrySet()) {
            set.add(new IdentityMapEntry(((IdentityKey)me.getKey()).key, me.getValue()));
        }
        return set;
    }

    public List entryList() {
        ArrayList<IdentityMapEntry> list = new ArrayList<IdentityMapEntry>(this.map.size());
        for (Map.Entry me : this.map.entrySet()) {
            list.add(new IdentityMapEntry(((IdentityKey)me.getKey()).key, me.getValue()));
        }
        return list;
    }

    public Map.Entry[] entryArray() {
        if (this.dirty) {
            this.entryArray = new Map.Entry[this.map.size()];
            Iterator iter = this.map.entrySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                Map.Entry me = iter.next();
                this.entryArray[i++] = new IdentityMapEntry(((IdentityKey)me.getKey()).key, me.getValue());
            }
            this.dirty = false;
        }
        return this.entryArray;
    }

    public static Object serialize(Map map) {
        return ((IdentityMap)map).map;
    }

    public static Map deserialize(Object o) {
        return new IdentityMap((Map)o);
    }

    public String toString() {
        return this.map.toString();
    }

    public static Map invert(Map map) {
        Map result = IdentityMap.instantiate(map.size());
        for (Map.Entry me : map.entrySet()) {
            result.put(me.getValue(), me.getKey());
        }
        return result;
    }

    static final class KeyIterator
    implements Iterator {
        private final Iterator identityKeyIterator;

        private KeyIterator(Iterator iter) {
            this.identityKeyIterator = iter;
        }

        @Override
        public boolean hasNext() {
            return this.identityKeyIterator.hasNext();
        }

        public Object next() {
            return ((IdentityKey)this.identityKeyIterator.next()).key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class IdentityKey
    implements Serializable {
        private Object key;

        IdentityKey(Object key) {
            this.key = key;
        }

        public boolean equals(Object other) {
            return this.key == ((IdentityKey)other).key;
        }

        public int hashCode() {
            return System.identityHashCode(this.key);
        }

        public String toString() {
            return this.key.toString();
        }

        public Object getRealKey() {
            return this.key;
        }
    }

    public static final class IdentityMapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        IdentityMapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object result = this.value;
            this.value = value;
            return result;
        }
    }
}

