/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.LiteralType;
import org.hibernate.type.MutableType;

public class TimeType
extends MutableType
implements LiteralType {
    private static final String TIME_FORMAT = "HH:mm:ss";

    @Override
    public Object get(ResultSet rs, String name) throws SQLException {
        return rs.getTime(name);
    }

    @Override
    public Class getReturnedClass() {
        return Date.class;
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        Time time = value instanceof Time ? (Time)value : new Time(((Date)value).getTime());
        st.setTime(index, time);
    }

    @Override
    public int sqlType() {
        return 92;
    }

    @Override
    public String getName() {
        return "time";
    }

    @Override
    public String toString(Object val) {
        return new SimpleDateFormat(TIME_FORMAT).format((Date)val);
    }

    @Override
    public boolean isEqual(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Date xdate = (Date)x;
        Date ydate = (Date)y;
        if (xdate.getTime() == ydate.getTime()) {
            return true;
        }
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime(xdate);
        calendar2.setTime(ydate);
        return calendar1.get(11) == calendar2.get(11) && calendar1.get(12) == calendar2.get(12) && calendar1.get(13) == calendar2.get(13) && calendar1.get(14) == calendar2.get(14);
    }

    @Override
    public int getHashCode(Object x, EntityMode entityMode) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)x);
        int hashCode = 1;
        hashCode = 31 * hashCode + calendar.get(11);
        hashCode = 31 * hashCode + calendar.get(12);
        hashCode = 31 * hashCode + calendar.get(13);
        hashCode = 31 * hashCode + calendar.get(14);
        return hashCode;
    }

    @Override
    public Object deepCopyNotNull(Object value) {
        return new Time(((Date)value).getTime());
    }

    @Override
    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return '\'' + new Time(((Date)value).getTime()).toString() + '\'';
    }

    @Override
    public Object fromStringValue(String xml) throws HibernateException {
        try {
            return new SimpleDateFormat(TIME_FORMAT).parse(xml);
        }
        catch (ParseException pe) {
            throw new HibernateException("could not parse XML", pe);
        }
    }
}

