/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;

public class CharacterType
extends PrimitiveType
implements DiscriminatorType {
    @Override
    public Serializable getDefaultValue() {
        throw new UnsupportedOperationException("not a valid id type");
    }

    @Override
    public Object get(ResultSet rs, String name) throws SQLException {
        String str = rs.getString(name);
        if (str == null) {
            return null;
        }
        return new Character(str.charAt(0));
    }

    @Override
    public Class getPrimitiveClass() {
        return Character.TYPE;
    }

    @Override
    public Class getReturnedClass() {
        return Character.class;
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        st.setString(index, value.toString());
    }

    @Override
    public int sqlType() {
        return 1;
    }

    @Override
    public String getName() {
        return "character";
    }

    @Override
    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return '\'' + value.toString() + '\'';
    }

    @Override
    public Object stringToObject(String xml) throws Exception {
        if (xml.length() != 1) {
            throw new MappingException("multiple or zero characters found parsing string");
        }
        return new Character(xml.charAt(0));
    }

    @Override
    public Object fromStringValue(String xml) {
        return new Character(xml.charAt(0));
    }
}

