/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.criteria;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.loader.OuterJoinLoader;
import org.hibernate.loader.criteria.CriteriaJoinWalker;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class CriteriaLoader
extends OuterJoinLoader {
    private final CriteriaQueryTranslator translator;
    private final Set querySpaces;
    private final Type[] resultTypes;
    private final String[] userAliases;
    private final boolean[] includeInResultRow;
    private final int resultRowLength;

    public CriteriaLoader(OuterJoinLoadable persister, SessionFactoryImplementor factory, CriteriaImpl criteria, String rootEntityName, Map enabledFilters) throws HibernateException {
        super(factory, enabledFilters);
        this.translator = new CriteriaQueryTranslator(factory, criteria, rootEntityName, "this_");
        this.querySpaces = this.translator.getQuerySpaces();
        CriteriaJoinWalker walker = new CriteriaJoinWalker(persister, this.translator, factory, criteria, rootEntityName, enabledFilters);
        this.initFromWalker(walker);
        this.userAliases = walker.getUserAliases();
        this.resultTypes = walker.getResultTypes();
        this.includeInResultRow = walker.includeInResultRow();
        this.resultRowLength = ArrayHelper.countTrue(this.includeInResultRow);
        this.postInstantiate();
    }

    public ScrollableResults scroll(SessionImplementor session, ScrollMode scrollMode) throws HibernateException {
        QueryParameters qp = this.translator.getQueryParameters();
        qp.setScrollMode(scrollMode);
        return this.scroll(qp, this.resultTypes, null, session);
    }

    public List list(SessionImplementor session) throws HibernateException {
        return this.list(session, this.translator.getQueryParameters(), this.querySpaces, this.resultTypes);
    }

    @Override
    protected Object getResultColumnOrRow(Object[] row, ResultTransformer transformer, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        return this.resolveResultTransformer(transformer).transformTuple(this.getResultRow(row, rs, session), this.getResultRowAliases());
    }

    @Override
    protected Object[] getResultRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        Object[] result;
        if (this.translator.hasProjection()) {
            Type[] types = this.translator.getProjectedTypes();
            result = new Object[types.length];
            String[] columnAliases = this.translator.getProjectedColumnAliases();
            for (int i = 0; i < result.length; ++i) {
                result[i] = types[i].nullSafeGet(rs, columnAliases[i], session, null);
            }
        } else {
            result = this.toResultRow(row);
        }
        return result;
    }

    private Object[] toResultRow(Object[] row) {
        if (this.resultRowLength == row.length) {
            return row;
        }
        Object[] result = new Object[this.resultRowLength];
        int j = 0;
        for (int i = 0; i < row.length; ++i) {
            if (!this.includeInResultRow[i]) continue;
            result[j++] = row[i];
        }
        return result;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    @Override
    protected String[] getResultRowAliases() {
        return this.userAliases;
    }

    @Override
    protected ResultTransformer resolveResultTransformer(ResultTransformer resultTransformer) {
        return this.translator.getRootCriteria().getResultTransformer();
    }

    @Override
    protected boolean areResultSetRowsTransformedImmediately() {
        return true;
    }

    @Override
    protected boolean[] includeInResultRow() {
        return this.includeInResultRow;
    }

    @Override
    protected String applyLocks(String sqlSelectString, Map lockModes, Dialect dialect) throws QueryException {
        if (lockModes == null || lockModes.isEmpty()) {
            return sqlSelectString;
        }
        HashMap<String, LockMode> aliasedLockModes = new HashMap<String, LockMode>();
        HashMap<String, String[]> keyColumnNames = dialect.forUpdateOfColumns() ? new HashMap<String, String[]>() : null;
        String[] drivingSqlAliases = this.getAliases();
        for (int i = 0; i < drivingSqlAliases.length; ++i) {
            LockMode lockMode = (LockMode)lockModes.get(drivingSqlAliases[i]);
            if (lockMode == null) continue;
            Lockable drivingPersister = (Lockable)((Object)this.getEntityPersisters()[i]);
            String rootSqlAlias = drivingPersister.getRootTableAlias(drivingSqlAliases[i]);
            aliasedLockModes.put(rootSqlAlias, lockMode);
            if (keyColumnNames == null) continue;
            keyColumnNames.put(rootSqlAlias, drivingPersister.getRootTableIdentifierColumnNames());
        }
        return dialect.applyLocksToSql(sqlSelectString, aliasedLockModes, keyColumnNames);
    }

    @Override
    protected LockMode[] getLockModes(Map lockModes) {
        String[] entityAliases = this.getAliases();
        if (entityAliases == null) {
            return null;
        }
        int size = entityAliases.length;
        LockMode[] lockModesArray = new LockMode[size];
        for (int i = 0; i < size; ++i) {
            LockMode lockMode = (LockMode)lockModes.get(entityAliases[i]);
            lockModesArray[i] = lockMode == null ? LockMode.NONE : lockMode;
        }
        return lockModesArray;
    }

    @Override
    protected boolean isSubselectLoadingEnabled() {
        return this.hasSubselectLoadableCollections();
    }

    @Override
    protected List getResultList(List results, ResultTransformer resultTransformer) {
        return this.resolveResultTransformer(resultTransformer).transformList(results);
    }
}

