/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.loader.AbstractEntityJoinWalker;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class CriteriaJoinWalker
extends AbstractEntityJoinWalker {
    private final CriteriaQueryTranslator translator;
    private final Set querySpaces;
    private final Type[] resultTypes;
    private final boolean[] includeInResultRow;
    private final String[] userAliases;
    private final List userAliasList = new ArrayList();
    private final List resultTypeList = new ArrayList();
    private final List includeInResultRowList = new ArrayList();

    public Type[] getResultTypes() {
        return this.resultTypes;
    }

    public String[] getUserAliases() {
        return this.userAliases;
    }

    public boolean[] includeInResultRow() {
        return this.includeInResultRow;
    }

    public CriteriaJoinWalker(OuterJoinLoadable persister, CriteriaQueryTranslator translator, SessionFactoryImplementor factory, CriteriaImpl criteria, String rootEntityName, Map enabledFilters) {
        this(persister, translator, factory, criteria, rootEntityName, enabledFilters, null);
    }

    public CriteriaJoinWalker(OuterJoinLoadable persister, CriteriaQueryTranslator translator, SessionFactoryImplementor factory, CriteriaImpl criteria, String rootEntityName, Map enabledFilters, String alias) {
        super(persister, factory, enabledFilters, alias);
        this.translator = translator;
        this.querySpaces = translator.getQuerySpaces();
        if (translator.hasProjection()) {
            this.initProjection(translator.getSelect(), translator.getWhereCondition(), translator.getOrderBy(), translator.getGroupBy(), LockMode.NONE);
            this.resultTypes = translator.getProjectedTypes();
            this.userAliases = translator.getProjectedAliases();
            this.includeInResultRow = new boolean[this.resultTypes.length];
            Arrays.fill(this.includeInResultRow, true);
        } else {
            this.initAll(translator.getWhereCondition(), translator.getOrderBy(), LockMode.NONE);
            this.userAliasList.add(criteria.getAlias());
            this.resultTypeList.add(translator.getResultType(criteria));
            this.includeInResultRowList.add(true);
            this.userAliases = ArrayHelper.toStringArray(this.userAliasList);
            this.resultTypes = ArrayHelper.toTypeArray(this.resultTypeList);
            this.includeInResultRow = ArrayHelper.toBooleanArray(this.includeInResultRowList);
        }
    }

    @Override
    protected int getJoinType(AssociationType type, FetchMode config, String path, String lhsTable, String[] lhsColumns, boolean nullable, int currentDepth, CascadeStyle cascadeStyle) throws MappingException {
        if (this.translator.isJoin(path)) {
            return this.translator.getJoinType(path);
        }
        if (this.translator.hasProjection()) {
            return -1;
        }
        FetchMode fetchMode = this.translator.getRootCriteria().getFetchMode(path);
        if (CriteriaJoinWalker.isDefaultFetchMode(fetchMode)) {
            return super.getJoinType(type, config, path, lhsTable, lhsColumns, nullable, currentDepth, cascadeStyle);
        }
        if (fetchMode == FetchMode.JOIN) {
            this.isDuplicateAssociation(lhsTable, lhsColumns, type);
            return this.getJoinType(nullable, currentDepth);
        }
        return -1;
    }

    private static boolean isDefaultFetchMode(FetchMode fetchMode) {
        return fetchMode == null || fetchMode == FetchMode.DEFAULT;
    }

    @Override
    protected String getWhereFragment() throws MappingException {
        return super.getWhereFragment() + ((Queryable)this.getPersister()).filterFragment(this.getAlias(), this.getEnabledFilters());
    }

    @Override
    protected String generateTableAlias(int n, String path, Joinable joinable) {
        if (joinable.consumesEntityAlias()) {
            String sqlAlias;
            Criteria subcriteria = this.translator.getCriteria(path);
            String string = sqlAlias = subcriteria == null ? null : this.translator.getSQLAlias(subcriteria);
            if (sqlAlias != null) {
                if (!this.translator.hasProjection()) {
                    this.includeInResultRowList.add(subcriteria.getAlias() != null);
                    if (subcriteria.getAlias() != null) {
                        this.userAliasList.add(subcriteria.getAlias());
                        this.resultTypeList.add(this.translator.getResultType(subcriteria));
                    }
                }
                return sqlAlias;
            }
            if (!this.translator.hasProjection()) {
                this.includeInResultRowList.add(false);
            }
        }
        return super.generateTableAlias(n + this.translator.getSQLAliasCount(), path, joinable);
    }

    @Override
    protected String generateRootAlias(String tableName) {
        return "this_";
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    @Override
    public String getComment() {
        return "criteria query";
    }
}

