/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.spi.ObjectFactory;
import org.hibernate.SessionFactory;
import org.hibernate.util.NamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFactoryObjectFactory
implements ObjectFactory {
    private static final SessionFactoryObjectFactory INSTANCE;
    private static final Logger log;
    private static final ConcurrentHashMap<String, SessionFactory> INSTANCES;
    private static final ConcurrentHashMap<String, SessionFactory> NAMED_INSTANCES;
    private static final NamingListener LISTENER;

    public Object getObjectInstance(Object reference, Name name, Context ctx, Hashtable env) throws Exception {
        log.debug("JNDI lookup: " + name);
        String uid = (String)((Reference)reference).get(0).getContent();
        return SessionFactoryObjectFactory.getInstance(uid);
    }

    public static void addInstance(String uid, String name, SessionFactory instance, Properties properties) {
        log.debug("registered: " + uid + " (" + (name == null ? "unnamed" : name) + ')');
        INSTANCES.put(uid, instance);
        if (name != null) {
            NAMED_INSTANCES.put(name, instance);
        }
        if (name == null) {
            log.info("Not binding factory to JNDI, no JNDI name configured");
        } else {
            log.info("Factory name: " + name);
            try {
                InitialContext ctx = NamingHelper.getInitialContext(properties);
                NamingHelper.bind(ctx, name, instance);
                log.info("Bound factory to JNDI name: " + name);
                ((EventContext)((Object)ctx)).addNamingListener(name, 0, LISTENER);
            }
            catch (InvalidNameException ine) {
                log.error("Invalid JNDI name: " + name, (Throwable)ine);
            }
            catch (NamingException ne) {
                log.warn("Could not bind factory to JNDI", (Throwable)ne);
            }
            catch (ClassCastException cce) {
                log.warn("InitialContext did not implement EventContext");
            }
        }
    }

    public static void removeInstance(String uid, String name, Properties properties) {
        if (name != null) {
            log.info("Unbinding factory from JNDI name: " + name);
            try {
                InitialContext ctx = NamingHelper.getInitialContext(properties);
                ctx.unbind(name);
                log.info("Unbound factory from JNDI name: " + name);
            }
            catch (InvalidNameException ine) {
                log.error("Invalid JNDI name: " + name, (Throwable)ine);
            }
            catch (NamingException ne) {
                log.warn("Could not unbind factory from JNDI", (Throwable)ne);
            }
            NAMED_INSTANCES.remove(name);
        }
        INSTANCES.remove(uid);
    }

    public static Object getNamedInstance(String name) {
        log.debug("lookup: name=" + name);
        SessionFactory result = NAMED_INSTANCES.get(name);
        if (result == null) {
            log.debug("Not found: " + name);
            log.debug(NAMED_INSTANCES.toString());
        }
        return result;
    }

    public static Object getInstance(String uid) {
        log.debug("lookup: uid=" + uid);
        SessionFactory result = INSTANCES.get(uid);
        if (result == null) {
            log.debug("Not found: " + uid);
            log.debug(INSTANCES.toString());
        }
        return result;
    }

    static {
        log = LoggerFactory.getLogger(SessionFactoryObjectFactory.class);
        INSTANCE = new SessionFactoryObjectFactory();
        log.debug("initializing class SessionFactoryObjectFactory");
        INSTANCES = new ConcurrentHashMap();
        NAMED_INSTANCES = new ConcurrentHashMap();
        LISTENER = new NamespaceChangeListener(){

            @Override
            public void objectAdded(NamingEvent evt) {
                log.debug("A factory was successfully bound to name: " + evt.getNewBinding().getName());
            }

            @Override
            public void objectRemoved(NamingEvent evt) {
                String name = evt.getOldBinding().getName();
                log.info("A factory was unbound from name: " + name);
                Object instance = NAMED_INSTANCES.remove(name);
                Iterator iter = INSTANCES.values().iterator();
                while (iter.hasNext()) {
                    if (iter.next() != instance) continue;
                    iter.remove();
                }
            }

            @Override
            public void objectRenamed(NamingEvent evt) {
                String name = evt.getOldBinding().getName();
                log.info("A factory was renamed from name: " + name);
                NAMED_INSTANCES.put(evt.getNewBinding().getName(), NAMED_INSTANCES.remove(name));
            }

            @Override
            public void namingExceptionThrown(NamingExceptionEvent evt) {
                log.warn("Naming exception occurred accessing factory: " + evt.getException());
            }
        };
    }
}

