/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.impl.AbstractQueryImpl;

public class QueryImpl
extends AbstractQueryImpl {
    private Map lockModes = new HashMap(2);

    public QueryImpl(String queryString, FlushMode flushMode, SessionImplementor session, ParameterMetadata parameterMetadata) {
        super(queryString, flushMode, session, parameterMetadata);
    }

    public QueryImpl(String queryString, SessionImplementor session, ParameterMetadata parameterMetadata) {
        this(queryString, null, session, parameterMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator iterate() throws HibernateException {
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        this.before();
        try {
            Iterator iterator = this.getSession().iterate(this.expandParameterLists(namedParams), this.getQueryParameters(namedParams));
            return iterator;
        }
        finally {
            this.after();
        }
    }

    @Override
    public ScrollableResults scroll() throws HibernateException {
        return this.scroll(ScrollMode.SCROLL_INSENSITIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        this.before();
        QueryParameters qp = this.getQueryParameters(namedParams);
        qp.setScrollMode(scrollMode);
        try {
            ScrollableResults scrollableResults = this.getSession().scroll(this.expandParameterLists(namedParams), qp);
            return scrollableResults;
        }
        finally {
            this.after();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List list() throws HibernateException {
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        this.before();
        try {
            List list = this.getSession().list(this.expandParameterLists(namedParams), this.getQueryParameters(namedParams));
            return list;
        }
        finally {
            this.after();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws HibernateException {
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        this.before();
        try {
            int n = this.getSession().executeUpdate(this.expandParameterLists(namedParams), this.getQueryParameters(namedParams));
            return n;
        }
        finally {
            this.after();
        }
    }

    @Override
    public Query setLockMode(String alias, LockMode lockMode) {
        this.lockModes.put(alias, lockMode);
        return this;
    }

    @Override
    protected Map getLockModes() {
        return this.lockModes;
    }
}

