/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import org.hibernate.MappingException;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionValue {
    private static final Logger log = LoggerFactory.getLogger(VersionValue.class);
    private final Object value;
    public static final VersionValue NULL = new VersionValue(){

        @Override
        public final Boolean isUnsaved(Object version) {
            log.trace("version unsaved-value strategy NULL");
            return version == null ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public Object getDefaultValue(Object currentValue) {
            return null;
        }

        @Override
        public String toString() {
            return "VERSION_SAVE_NULL";
        }
    };
    public static final VersionValue UNDEFINED = new VersionValue(){

        @Override
        public final Boolean isUnsaved(Object version) {
            log.trace("version unsaved-value strategy UNDEFINED");
            return version == null ? Boolean.TRUE : null;
        }

        @Override
        public Object getDefaultValue(Object currentValue) {
            return currentValue;
        }

        @Override
        public String toString() {
            return "VERSION_UNDEFINED";
        }
    };
    public static final VersionValue NEGATIVE = new VersionValue(){

        @Override
        public final Boolean isUnsaved(Object version) throws MappingException {
            log.trace("version unsaved-value strategy NEGATIVE");
            if (version == null) {
                return Boolean.TRUE;
            }
            if (version instanceof Number) {
                return ((Number)version).longValue() < 0L ? Boolean.TRUE : Boolean.FALSE;
            }
            throw new MappingException("unsaved-value NEGATIVE may only be used with short, int and long types");
        }

        @Override
        public Object getDefaultValue(Object currentValue) {
            return IdentifierGeneratorFactory.createNumber(-1L, currentValue.getClass());
        }

        @Override
        public String toString() {
            return "VERSION_NEGATIVE";
        }
    };

    protected VersionValue() {
        this.value = null;
    }

    public VersionValue(Object value) {
        this.value = value;
    }

    public Boolean isUnsaved(Object version) throws MappingException {
        if (log.isTraceEnabled()) {
            log.trace("version unsaved-value: " + this.value);
        }
        return version == null || version.equals(this.value) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object getDefaultValue(Object currentValue) {
        return this.value;
    }

    public String toString() {
        return "version unsaved-value: " + this.value;
    }
}

