/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.QueryKey;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardQueryCache
implements QueryCache {
    private static final Logger log = LoggerFactory.getLogger(StandardQueryCache.class);
    private QueryResultsRegion cacheRegion;
    private UpdateTimestampsCache updateTimestampsCache;

    @Override
    public void clear() throws CacheException {
        this.cacheRegion.evictAll();
    }

    public StandardQueryCache(Settings settings, Properties props, UpdateTimestampsCache updateTimestampsCache, String regionName) throws HibernateException {
        String prefix;
        if (regionName == null) {
            regionName = StandardQueryCache.class.getName();
        }
        if ((prefix = settings.getCacheRegionPrefix()) != null) {
            regionName = prefix + '.' + regionName;
        }
        log.info("starting query cache at region: " + regionName);
        this.cacheRegion = settings.getRegionFactory().buildQueryResultsRegion(regionName, props);
        this.updateTimestampsCache = updateTimestampsCache;
    }

    @Override
    public boolean put(QueryKey key, Type[] returnTypes, List result, boolean isNaturalKeyLookup, SessionImplementor session) throws HibernateException {
        if (isNaturalKeyLookup && result.size() == 0) {
            return false;
        }
        Long ts = new Long(session.getFactory().getSettings().getRegionFactory().nextTimestamp());
        if (log.isDebugEnabled()) {
            log.debug("caching query results in region: " + this.cacheRegion.getName() + "; timestamp=" + ts);
        }
        ArrayList<Object> cacheable = new ArrayList<Object>(result.size() + 1);
        if (log.isTraceEnabled()) {
            StandardQueryCache.logCachedResultDetails(key, null, returnTypes, cacheable);
        }
        cacheable.add(ts);
        for (int i = 0; i < result.size(); ++i) {
            if (returnTypes.length == 1) {
                cacheable.add(returnTypes[0].disassemble(result.get(i), session, null));
            } else {
                cacheable.add(TypeFactory.disassemble((Object[])result.get(i), returnTypes, null, session, null));
            }
            if (!log.isTraceEnabled()) continue;
            StandardQueryCache.logCachedResultRowDetails(returnTypes, result.get(i));
        }
        this.cacheRegion.put(key, cacheable);
        return true;
    }

    @Override
    public List get(QueryKey key, Type[] returnTypes, boolean isNaturalKeyLookup, Set spaces, SessionImplementor session) throws HibernateException {
        if (log.isDebugEnabled()) {
            log.debug("checking cached query results in region: " + this.cacheRegion.getName());
        }
        List cacheable = (List)this.cacheRegion.get(key);
        if (log.isTraceEnabled()) {
            StandardQueryCache.logCachedResultDetails(key, spaces, returnTypes, cacheable);
        }
        if (cacheable == null) {
            log.debug("query results were not found in cache");
            return null;
        }
        Long timestamp = (Long)cacheable.get(0);
        if (!isNaturalKeyLookup && !this.isUpToDate(spaces, timestamp)) {
            log.debug("cached query results were not up to date");
            return null;
        }
        log.debug("returning cached query results");
        for (int i = 1; i < cacheable.size(); ++i) {
            if (returnTypes.length == 1) {
                returnTypes[0].beforeAssemble((Serializable)cacheable.get(i), session);
                continue;
            }
            TypeFactory.beforeAssemble((Serializable[])cacheable.get(i), returnTypes, session);
        }
        ArrayList<Object> result = new ArrayList<Object>(cacheable.size() - 1);
        for (int i = 1; i < cacheable.size(); ++i) {
            try {
                if (returnTypes.length == 1) {
                    result.add(returnTypes[0].assemble((Serializable)cacheable.get(i), session, null));
                } else {
                    result.add(TypeFactory.assemble((Serializable[])cacheable.get(i), returnTypes, session, null));
                }
                if (!log.isTraceEnabled()) continue;
                StandardQueryCache.logCachedResultRowDetails(returnTypes, result.get(i - 1));
                continue;
            }
            catch (UnresolvableObjectException uoe) {
                if (isNaturalKeyLookup) {
                    log.debug("could not reassemble cached result set");
                    this.cacheRegion.evict(key);
                    return null;
                }
                throw uoe;
            }
        }
        return result;
    }

    protected boolean isUpToDate(Set spaces, Long timestamp) {
        if (log.isDebugEnabled()) {
            log.debug("Checking query spaces for up-to-dateness: " + spaces);
        }
        return this.updateTimestampsCache.isUpToDate(spaces, timestamp);
    }

    @Override
    public void destroy() {
        try {
            this.cacheRegion.destroy();
        }
        catch (Exception e) {
            log.warn("could not destroy query cache: " + this.cacheRegion.getName(), (Throwable)e);
        }
    }

    @Override
    public QueryResultsRegion getRegion() {
        return this.cacheRegion;
    }

    public String toString() {
        return "StandardQueryCache(" + this.cacheRegion.getName() + ')';
    }

    private static void logCachedResultDetails(QueryKey key, Set querySpaces, Type[] returnTypes, List result) {
        if (!log.isTraceEnabled()) {
            return;
        }
        log.trace("key.hashCode=" + key.hashCode());
        log.trace("querySpaces=" + querySpaces);
        if (returnTypes == null || returnTypes.length == 0) {
            log.trace("unexpected returnTypes is " + (returnTypes == null ? "null" : "empty") + "! result" + (result == null ? " is null" : ".size()=" + result.size()));
        } else {
            StringBuffer returnTypeInfo = new StringBuffer();
            for (int i = 0; i < returnTypes.length; ++i) {
                returnTypeInfo.append("typename=").append(returnTypes[i].getName()).append(" class=").append(returnTypes[i].getReturnedClass().getName()).append(' ');
            }
            log.trace(" returnTypeInfo=" + returnTypeInfo);
        }
    }

    private static void logCachedResultRowDetails(Type[] returnTypes, Object result) {
        Object[] objectArray;
        if (!log.isTraceEnabled()) {
            return;
        }
        if (result instanceof Object[]) {
            objectArray = (Object[])result;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = result;
        }
        StandardQueryCache.logCachedResultRowDetails(returnTypes, objectArray);
    }

    private static void logCachedResultRowDetails(Type[] returnTypes, Object[] tuple) {
        if (!log.isTraceEnabled()) {
            return;
        }
        if (tuple == null) {
            log.trace(" tuple is null; returnTypes is " + (returnTypes == null ? "null" : "Type[" + returnTypes.length + "]"));
            if (returnTypes != null && returnTypes.length > 1) {
                log.trace("unexpected result tuple! tuple is null; should be Object[" + returnTypes.length + "]!");
            }
        } else {
            if (returnTypes == null || returnTypes.length == 0) {
                log.trace("unexpected result tuple! tuple is non-null; returnTypes is " + (returnTypes == null ? "null" : "empty"));
            }
            log.trace(" tuple is Object[" + tuple.length + "]; returnTypes is Type[" + returnTypes.length + "]");
            if (tuple.length != returnTypes.length) {
                log.trace("unexpected tuple length! transformer= expected=" + returnTypes.length + " got=" + tuple.length);
            } else {
                for (int j = 0; j < tuple.length; ++j) {
                    if (tuple[j] == null || returnTypes[j].getReturnedClass().isInstance(tuple[j])) continue;
                    log.trace("unexpected tuple value type! transformer= expected=" + returnTypes[j].getReturnedClass().getName() + " got=" + tuple[j].getClass().getName());
                }
            }
        }
    }
}

