/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.javancss.ccl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import net.sourceforge.cobertura.javancss.ccl.Util;

public class FileUtil {
    private FileUtil() {
    }

    public static String concatPath(String sPath_, String sFile_) {
        Util.panicIf(sPath_ == null);
        String sRetVal = sPath_;
        if (!Util.isEmpty(sFile_)) {
            if (sPath_.length() > 0 && !sPath_.endsWith(File.separator)) {
                sRetVal = sRetVal + File.separator;
            }
            sRetVal = sRetVal + sFile_;
        }
        return sRetVal;
    }

    public static String readFile(String sFileName_) throws IOException, FileNotFoundException {
        StringBuffer sFileContent = new StringBuffer(100000);
        try {
            FileReader frIni = new FileReader(sFileName_);
            if (frIni != null) {
                BufferedReader brIni = new BufferedReader(frIni);
                if (brIni != null) {
                    String sLine;
                    while (brIni.ready() && (sLine = brIni.readLine()) != null) {
                        sFileContent.append(sLine).append('\n');
                    }
                    brIni.close();
                }
                frIni.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("No such file: '" + sFileName_ + "'");
        }
        return sFileContent.toString();
    }

    public static String getAbsoluteFileName(String sFileName_) {
        String sRetVal = null;
        try {
            File pFile = new File(sFileName_);
            sRetVal = pFile.getCanonicalPath();
        }
        catch (Exception e) {
            return null;
        }
        return sRetVal;
    }

    public static String normalizeFileName(String sFile) {
        return FileUtil.normalizeFileName(sFile, (String)System.getProperties().get("user.dir"));
    }

    private static String normalizeFileName(String sFile, String sUserDir) {
        if (Util.isEmpty(sFile = sFile.trim()) || sFile.equals(".")) {
            sFile = sUserDir;
        } else if (!FileUtil.isAbsolute(sFile)) {
            sFile = FileUtil.concatPath(sUserDir, sFile);
        }
        sFile = FileUtil.getAbsoluteFileName(sFile);
        return sFile;
    }

    private static boolean isAbsolute(String sFileName_) {
        return new File(sFileName_).isAbsolute();
    }
}

