/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.Collection;
import javassist.CtMember;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.util.logging.AOPLogger;

public class JoinpointSimpleClassifier
extends JoinpointClassifier {
    private static final AOPLogger logger = AOPLogger.getLogger(JoinpointSimpleClassifier.class);

    protected JoinpointClassification classifyJoinpoint(CtMember member, Advisor advisor, JoinpointClassifier.Matcher joinpointMatcher, JoinpointClassifier.BindingCollectionAccessor bindingCollectionAccessor) throws NotFoundException {
        Collection<Pointcut> pointcuts = bindingCollectionAccessor.getPointcuts(advisor);
        for (Pointcut pointcut : pointcuts) {
            if (!joinpointMatcher.matches(pointcut, advisor, member)) continue;
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug(joinpointMatcher.getJoinpointDescription(member) + " matches pointcut: " + pointcut.getExpr());
            }
            return JoinpointClassification.WRAPPED;
        }
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug(joinpointMatcher.getJoinpointDescription(member) + " matches no pointcuts");
        }
        return JoinpointClassification.NOT_INSTRUMENTED;
    }
}

