/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import org.jboss.aop.advice.annotation.AdviceMethodFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AdviceType {
    BEFORE("before", AdviceMethodFactory.BEFORE, true, "before"),
    AROUND("around", AdviceMethodFactory.AROUND, false, "around"),
    AFTER("after", AdviceMethodFactory.AFTER, false, "after"),
    THROWING("throwing", AdviceMethodFactory.THROWING, false, "after-throwing"),
    FINALLY("finally", AdviceMethodFactory.FINALLY, false, "finally");

    private String name;
    private String description;
    private String accessor;
    private AdviceMethodFactory factory;
    private boolean generatedOnly;

    private AdviceType(String name, AdviceMethodFactory factory, boolean generatedOnly, String description) {
        this.name = name;
        this.accessor = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        this.factory = factory;
        this.factory.setAdviceType(this);
        this.generatedOnly = generatedOnly;
        this.description = description;
    }

    public final String getName() {
        return this.name;
    }

    public final String getAccessor() {
        return this.accessor;
    }

    public final AdviceMethodFactory getFactory() {
        return this.factory;
    }

    public final boolean isGeneratedOnly() {
        return this.generatedOnly;
    }

    public String toString() {
        return this.description;
    }
}

