/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContextType;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.EntityManagerImpl;
import org.hibernate.ejb.HibernateEntityManagerFactory;

public class EntityManagerFactoryImpl
implements HibernateEntityManagerFactory {
    private SessionFactory sessionFactory;
    private PersistenceUnitTransactionType transactionType;
    private boolean discardOnClose;
    private Class sessionInterceptorClass;

    public EntityManagerFactoryImpl(SessionFactory sessionFactory, PersistenceUnitTransactionType transactionType, boolean discardOnClose, Class sessionInterceptorClass) {
        this.sessionFactory = sessionFactory;
        this.transactionType = transactionType;
        this.discardOnClose = discardOnClose;
        this.sessionInterceptorClass = sessionInterceptorClass;
    }

    public EntityManager createEntityManager() {
        return this.createEntityManager(null);
    }

    public EntityManager createEntityManager(Map map) {
        return new EntityManagerImpl(this.sessionFactory, PersistenceContextType.EXTENDED, this.transactionType, this.discardOnClose, this.sessionInterceptorClass, map);
    }

    public void close() {
        this.sessionFactory.close();
    }

    public boolean isOpen() {
        return !this.sessionFactory.isClosed();
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }
}

