/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transporter;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transporter.InternalTransporterServices;
import org.jboss.remoting.transporter.TransporterHandler;
import org.jboss.remoting.util.SecurityUtility;
import org.w3c.dom.Element;

public class TransporterServer {
    private Connector connector = null;

    public TransporterServer(InvokerLocator locator, Object target, String subsystem) throws Exception {
        this.connector = this.getConnector(locator, null, null);
        TransporterHandler handler = new TransporterHandler(target);
        if (subsystem != null) {
            this.connector.addInvocationHandler(subsystem.toUpperCase(), handler);
        } else {
            this.addInterfaceSubsystems(this.connector, handler, target);
        }
    }

    public TransporterServer(Element xmlConfig, Object target, String subsystem) throws Exception {
        this.connector = this.getConnector(null, null, xmlConfig);
        TransporterHandler handler = new TransporterHandler(target);
        if (subsystem != null) {
            this.connector.addInvocationHandler(subsystem.toUpperCase(), handler);
        } else {
            this.addInterfaceSubsystems(this.connector, handler, target);
        }
    }

    public TransporterServer(InvokerLocator locator, Object target, String subsystem, Map config) throws Exception {
        this.connector = this.getConnector(locator, config, null);
        TransporterHandler handler = new TransporterHandler(target);
        if (subsystem != null) {
            this.connector.addInvocationHandler(subsystem.toUpperCase(), handler);
        } else {
            this.addInterfaceSubsystems(this.connector, handler, target);
        }
    }

    private void addInterfaceSubsystems(Connector connector, ServerInvocationHandler handler, Object target) throws Exception {
        Class<?> targetClass = target.getClass();
        ArrayList interfaceNames = new ArrayList();
        this.populateInterfaceNames(interfaceNames, targetClass);
        for (int i = 0; i < interfaceNames.size(); ++i) {
            String interfaceClassName = (String)interfaceNames.get(i);
            connector.addInvocationHandler(interfaceClassName.toUpperCase(), handler);
        }
    }

    private void populateInterfaceNames(List interfaceNames, Class targetClass) {
        Class<?>[] interfaces = targetClass.getInterfaces();
        if (interfaces != null) {
            for (int x = 0; x < interfaces.length; ++x) {
                interfaceNames.add(interfaces[x].getName());
                this.populateInterfaceNames(interfaceNames, interfaces[x]);
            }
        }
    }

    protected Connector getConnector(InvokerLocator locator, Map config, Element xmlConfig) throws Exception {
        Connector c = new Connector(locator, config);
        if (xmlConfig != null) {
            c.setConfiguration(xmlConfig);
        }
        c.create();
        return c;
    }

    public void addHandler(Object target, String proxyclassname) throws Exception {
        if (this.connector == null) {
            throw new Exception("Can not add handler to transporter server as has not be initialized yet.");
        }
        this.connector.addInvocationHandler(proxyclassname, new TransporterHandler(target));
    }

    public void start() throws Exception {
        this.connector.start();
    }

    public void stop() {
        this.connector.stop();
    }

    private static void setupDetector() throws Exception {
        InternalTransporterServices services = InternalTransporterServices.getInstance();
        if (!services.isSetup()) {
            MBeanServer server = TransporterServer.createMBeanServer();
            MulticastDetector detector = new MulticastDetector();
            services.setup(server, detector, null, null, null, true, false);
            detector.start();
        } else if (services.getDetector() == null) {
            MulticastDetector detector = new MulticastDetector();
            services.assignDetector(detector, null, true);
            detector.start();
        }
    }

    public static TransporterServer createTransporterServer(InvokerLocator locator, Object target, String subsystem, boolean isClustered) throws Exception {
        return TransporterServer.createTransporterServer(locator, target, subsystem, null, isClustered);
    }

    public static TransporterServer createTransporterServer(InvokerLocator locator, Object target, String subsystem, Map config, boolean isClustered) throws Exception {
        if (isClustered && InternalTransporterServices.getInstance().getDetector() == null) {
            TransporterServer.setupDetector();
        }
        TransporterServer server = new TransporterServer(locator, target, subsystem, config);
        server.start();
        return server;
    }

    public static TransporterServer createTransporterServer(String locatorURI, Object target, String subsystem, boolean isClustered) throws Exception {
        return TransporterServer.createTransporterServer(new InvokerLocator(locatorURI), target, subsystem, null, isClustered);
    }

    public static TransporterServer createTransporterServer(String locatorURI, Object target, String subsystem, Map config, boolean isClustered) throws Exception {
        return TransporterServer.createTransporterServer(new InvokerLocator(locatorURI), target, subsystem, config, isClustered);
    }

    public static TransporterServer createTransporterServer(Element xmlconfig, Object target, String subsystem, boolean isClustered) throws Exception {
        if (isClustered && InternalTransporterServices.getInstance().getDetector() == null) {
            TransporterServer.setupDetector();
        }
        TransporterServer server = new TransporterServer(xmlconfig, target, subsystem);
        server.start();
        return server;
    }

    public static TransporterServer createTransporterServer(InvokerLocator locator, Object target, String subsystem) throws Exception {
        return TransporterServer.createTransporterServer(locator, target, subsystem, false);
    }

    public static TransporterServer createTransporterServer(InvokerLocator locator, Object target) throws Exception {
        return TransporterServer.createTransporterServer(locator, target, false);
    }

    public static TransporterServer createTransporterServer(InvokerLocator locator, Object target, boolean isClustered) throws Exception {
        if (isClustered && InternalTransporterServices.getInstance().getDetector() == null) {
            TransporterServer.setupDetector();
        }
        TransporterServer server = new TransporterServer(locator, target, null, null);
        server.start();
        return server;
    }

    public static TransporterServer createTransporterServer(String locator, Object target) throws Exception {
        return TransporterServer.createTransporterServer(new InvokerLocator(locator), target, false);
    }

    public static TransporterServer createTransporterServer(String locator, Object target, boolean isClustered) throws Exception {
        return TransporterServer.createTransporterServer(new InvokerLocator(locator), target, isClustered);
    }

    public static TransporterServer createTransporterServer(String locatorURI, Object target, String subsystem) throws Exception {
        return TransporterServer.createTransporterServer(new InvokerLocator(locatorURI), target, subsystem, false);
    }

    private static MBeanServer createMBeanServer() throws Exception {
        if (SecurityUtility.skipAccessControl()) {
            return MBeanServerFactory.createMBeanServer();
        }
        try {
            return (MBeanServer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return MBeanServerFactory.createMBeanServer();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (Exception)e.getCause();
        }
    }
}

