/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.serializable;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import org.jboss.remoting.Version;
import org.jboss.remoting.marshal.PreferredStreamUnMarshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.UpdateableClassloaderUnMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.serialization.SerializationManager;
import org.jboss.remoting.serialization.SerializationStreamFactory;

public class SerializableUnMarshaller
implements PreferredStreamUnMarshaller,
VersionedUnMarshaller,
UpdateableClassloaderUnMarshaller {
    static final long serialVersionUID = -1554017376768780738L;
    public static final String DATATYPE = "serializable";
    protected ClassLoader customClassLoader;
    protected String serializationType;

    @Override
    public InputStream getMarshallingStream(InputStream inputStream) throws IOException {
        return this.getMarshallingStream(inputStream, null);
    }

    @Override
    public InputStream getMarshallingStream(InputStream inputStream, Map config) throws IOException {
        if (inputStream instanceof ObjectInputStream) {
            return inputStream;
        }
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        SerializationManager manager = SerializationStreamFactory.getManagerInstance(this.getSerializationType());
        return manager.createInput(bis, this.getClassLoader());
    }

    @Override
    public Object read(InputStream inputStream, Map metadata) throws IOException, ClassNotFoundException {
        int version = Version.getDefaultVersion();
        return this.read(inputStream, metadata, version);
    }

    @Override
    public Object read(InputStream inputStream, Map metadata, int version) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = (ObjectInputStream)this.getMarshallingStream(inputStream, null);
        return SerializationStreamFactory.getManagerInstance(this.getSerializationType()).receiveObject(ois, this.getClassLoader(), version);
    }

    @Override
    public void setClassLoader(ClassLoader classloader) {
        this.customClassLoader = classloader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.customClassLoader;
    }

    @Override
    public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException {
        SerializableUnMarshaller unmarshaller = new SerializableUnMarshaller();
        unmarshaller.setClassLoader(this.getClassLoader());
        return unmarshaller;
    }

    @Override
    public void setSerializationType(String serializationType) {
        this.serializationType = serializationType;
    }

    @Override
    public String getSerializationType() {
        if (this.serializationType == null) {
            return "java";
        }
        return this.serializationType;
    }
}

