/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.lookup;

import org.apache.commons.logging.Log;
import org.apache.tools.ant.types.EnumeratedAttribute;
import xdoclet.XDocletException;
import xdoclet.XDocletMessages;
import xdoclet.modules.ejb.AbstractEjbCodeGeneratorSubTask;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.modules.ejb.XDocletModulesEjbMessages;
import xdoclet.modules.ejb.lookup.LookupUtilTagsHandler;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xjavadoc.XClass;

public class LookupObjectSubTask
extends AbstractEjbCodeGeneratorSubTask {
    public static final String DEFAULT_UTIL_CLASS_PATTERN = "{0}Util";
    private static String DEFAULT_TEMPLATE_FILE = "resources/lookup.xdt";
    private String utilClassPattern;
    private boolean includeGUID = false;
    private boolean cacheHomes = false;
    private String kind = "logical";
    private boolean localProxies = false;

    public LookupObjectSubTask() {
        this.setTemplateURL(((Object)((Object)this)).getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(this.getUtilClassPattern() + ".java");
        this.addOfType("javax.ejb.EntityBean");
        this.addOfType("javax.ejb.SessionBean");
        this.addOfType("javax.ejb.MessageDrivenBean");
    }

    public boolean getLocalProxies() {
        return this.localProxies;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean getIncludeGUID() {
        return this.includeGUID;
    }

    public boolean getCacheHomes() {
        return this.cacheHomes;
    }

    public String getUtilClassPattern() {
        if (this.utilClassPattern != null) {
            return this.utilClassPattern;
        }
        return DEFAULT_UTIL_CLASS_PATTERN;
    }

    public void setLocalProxies(boolean localProxies) {
        this.localProxies = localProxies;
    }

    public void setKind(LookupKind kind) {
        this.kind = kind.getValue();
    }

    public void setPattern(String new_pattern) {
        this.utilClassPattern = new_pattern;
    }

    public void setIncludeGUID(boolean includeGUID) {
        this.includeGUID = includeGUID;
    }

    public void setCacheHomes(boolean cacheHomes) {
        this.cacheHomes = cacheHomes;
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (this.getUtilClassPattern() == null || this.getUtilClassPattern().trim().equals("")) {
            throw new XDocletException(Translator.getString(XDocletMessages.class, (String)"PARAMETER_MISSING_OR_EMPTY", (String[])new String[]{"pattern"}));
        }
        if (this.getUtilClassPattern().indexOf("{0}") == -1) {
            throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, (String)"PATTERN_HAS_NO_PLACEHOLDER"));
        }
    }

    protected String getGeneratedFileName(XClass clazz) throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor((String)LookupUtilTagsHandler.getUtilClassFor(this.getCurrentClass())) + ".java";
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString(XDocletModulesEjbMessages.class, (String)"GENERATING_UTIL_FOR", (String[])new String[]{this.getCurrentClass().getQualifiedName()}));
    }

    protected boolean matchesGenerationRules(XClass clazz) throws XDocletException {
        Log log = LogUtil.getLog(LookupObjectSubTask.class, (String)"matchesGenerationRules");
        if (!super.matchesGenerationRules(clazz)) {
            log.debug((Object)("Skip bean " + clazz.getQualifiedName() + " because super.matchesGenerationRules() returned false."));
            return false;
        }
        if (!EjbTagsHandler.isAConcreteEJBean(this.getCurrentClass())) {
            log.debug((Object)("Skip bean " + clazz.getQualifiedName() + " because it's not a concrete bean."));
            return false;
        }
        String generate = this.getCurrentClass().getDoc().getTagAttributeValue("ejb:util", "generate", true);
        if (generate != null && (generate.equals("false") || generate.equals("no"))) {
            log.debug((Object)("Skip util class for " + clazz.getQualifiedName() + " because of generate=" + generate + " flag."));
            return false;
        }
        return true;
    }

    public static class LookupKind
    extends EnumeratedAttribute {
        public static final String PHYSICAL = "physical";
        public static final String LOGICAL = "logical";

        public String[] getValues() {
            return new String[]{PHYSICAL, LOGICAL};
        }
    }
}

