/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tagshandler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import xdoclet.DocletContext;
import xdoclet.XDocletException;
import xdoclet.XDocletMessages;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.template.TemplateException;
import xdoclet.util.Translator;
import xjavadoc.XClass;
import xjavadoc.XPackage;

public class PackageTagsHandler
extends AbstractProgramElementTagsHandler {
    public static String getPackageNameFor(XPackage pak, boolean withSubstitution) {
        return PackageTagsHandler.getPackageNameFor(pak.getName(), withSubstitution);
    }

    public static String getPackageNameFor(String packageName) {
        return PackageTagsHandler.getPackageNameFor(packageName, true);
    }

    public static String getPackageNameFor(String packageName, boolean withSubstitution) {
        ArrayList packageSubstitutions = PackageTagsHandler.getPackageSubstitutions(DocletContext.getInstance().getActiveSubTask().getSubTaskName());
        if (packageSubstitutions == null || !withSubstitution) {
            return packageName;
        }
        block0: for (int i = 0; i < packageSubstitutions.size(); ++i) {
            PackageSubstitution ps = (PackageSubstitution)packageSubstitutions.get(i);
            StringTokenizer st = new StringTokenizer(ps.getPackages(), ",", false);
            if (!ps.getUseFirst()) {
                while (st.hasMoreTokens()) {
                    String packages = st.nextToken();
                    String suffix = "." + packages;
                    if (!packageName.endsWith(suffix)) continue;
                    if (ps.getSubstituteWith() == null || ps.getSubstituteWith().length() == 0) {
                        packageName = packageName.substring(0, packageName.length() - suffix.length());
                        continue block0;
                    }
                    packageName = packageName.substring(0, packageName.length() - suffix.length()) + '.' + ps.getSubstituteWith();
                    continue block0;
                }
                continue;
            }
            packageName = PackageTagsHandler.replaceInline(packageName, ps.getPackages(), ps.getSubstituteWith());
        }
        return packageName;
    }

    public static ArrayList getPackageSubstitutions(String subtaskName) {
        ArrayList packageSubstitutions = null;
        boolean supportsPackageSubstitutionInheritance = true;
        Boolean supports = (Boolean)DocletContext.getInstance().getConfigParam(subtaskName + ".packageSubstitutionInheritanceSupported");
        if (supports != null) {
            supportsPackageSubstitutionInheritance = supports;
        }
        packageSubstitutions = (ArrayList)DocletContext.getInstance().getConfigParam(subtaskName + ".packageSubstitutions");
        if (supportsPackageSubstitutionInheritance && (packageSubstitutions == null || packageSubstitutions.isEmpty())) {
            packageSubstitutions = (ArrayList)DocletContext.getInstance().getConfigParam("packageSubstitutions");
        }
        return packageSubstitutions;
    }

    public static String packageNameAsPathFor(XPackage pak) {
        return PackageTagsHandler.getPackageNameFor(pak, true).replace('.', '/');
    }

    public static String packageNameAsPathWithoutSubstitutionFor(XPackage pak) {
        return PackageTagsHandler.getPackageNameFor(pak, false).replace('.', '/');
    }

    public static String packageNameAsPathFor(String qualifiedName) {
        String qName = qualifiedName;
        ArrayList pss = PackageTagsHandler.getPackageSubstitutions(DocletContext.getInstance().getActiveSubTask().getSubTaskName());
        for (int i = 0; i < pss.size(); ++i) {
            PackageSubstitution ps = (PackageSubstitution)pss.get(i);
            if (!ps.getUseFirst()) continue;
            qName = PackageTagsHandler.replaceInline(qName, ps.getPackages(), ps.getSubstituteWith());
        }
        return qName.replace('.', '/');
    }

    public static String replaceInline(String original, String oldOne, String newOne) {
        int index = original.indexOf(oldOne);
        if (index > -1) {
            return original.substring(0, index) + newOne + original.substring(index + oldOne.length());
        }
        return original;
    }

    public String packageName() throws XDocletException {
        if (PackageTagsHandler.getCurrentPackage() != null) {
            return PackageTagsHandler.getCurrentPackage().getName();
        }
        return PackageTagsHandler.getCurrentClass().getContainingPackage().getName();
    }

    public void packageOf(String template) throws XDocletException {
        this.getEngine().print(this.getPackageNameFrom(template));
    }

    public void packageDeclarationOf(String template) throws XDocletException {
        String packageName = this.getPackageNameFrom(template);
        if (packageName != null && packageName.length() > 0) {
            this.getEngine().print("package " + packageName + ";");
        }
    }

    public void forAllPackages(String template, Properties attributes) throws XDocletException {
        Collection classes = PackageTagsHandler.getXJavaDoc().getSourceClasses();
        TreeSet<XPackage> packages = new TreeSet<XPackage>();
        for (XClass clazz : classes) {
            packages.add(clazz.getContainingPackage());
        }
        XPackage currentPackage2 = null;
        for (XPackage currentPackage2 : packages) {
            PackageTagsHandler.setCurrentPackage(currentPackage2);
            this.generate(template);
        }
        PackageTagsHandler.setCurrentPackage(null);
    }

    public String packageNameAsPath() throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor(this.packageName());
    }

    private String getPackageNameFrom(String template) throws XDocletException {
        try {
            String fullClassName = this.getEngine().outputOf(template);
            int pos = fullClassName.lastIndexOf(46);
            if (pos < 0) {
                return "";
            }
            return PackageTagsHandler.getPackageNameFor(fullClassName.substring(0, pos), true);
        }
        catch (TemplateException ex) {
            throw new XDocletException(ex, Translator.getString(XDocletMessages.class, "METHOD_FAILED", new String[]{"packageOf"}));
        }
    }

    public static class PackageSubstitution
    implements Serializable {
        private String packages = null;
        private String substituteWith = null;
        private boolean useFirst = false;

        public String getPackages() {
            return this.packages;
        }

        public String getSubstituteWith() {
            return this.substituteWith;
        }

        public boolean getUseFirst() {
            return this.useFirst;
        }

        public void setPackages(String packages) {
            this.packages = packages;
        }

        public void setSubstituteWith(String substituteWith) {
            this.substituteWith = substituteWith;
        }

        public void setUseFirst(boolean first) {
            this.useFirst = first;
        }
    }
}

