/*
 * Decompiled with CFR 0.152.
 */
package xdoclet;

import java.net.URL;
import org.apache.commons.logging.Log;
import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;
import xdoclet.tagshandler.IdTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.XmlValidator;

public class XmlSubTask
extends TemplateSubTask {
    private boolean useIds = false;
    private String xmlEncoding = "UTF-8";
    private boolean validateXML = false;
    private String publicId = null;
    private String systemId = null;
    private URL dtdURL = null;
    private String schema = null;
    private URL schemaURL = null;

    public boolean getUseIds() {
        return this.useIds;
    }

    public String getXmlencoding() {
        return this.xmlEncoding;
    }

    public URL getDtdURL() {
        return this.dtdURL;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean isValidateXML() {
        return this.validateXML;
    }

    public URL getSchemaURL() {
        return this.schemaURL;
    }

    public void setUseIds(boolean useIds) {
        this.useIds = useIds;
    }

    public void setXmlencoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setValidateXML(boolean flag) {
        this.validateXML = flag;
    }

    @Override
    public void copyAttributesFrom(TemplateSubTask templateSrc) {
        super.copyAttributesFrom(templateSrc);
        XmlSubTask src = (XmlSubTask)templateSrc;
        this.setValidateXML(src.isValidateXML());
        this.setPublicId(src.getPublicId());
        this.setSystemId(src.getSystemId());
        this.setDtdURL(src.getDtdURL());
        this.setSchema(src.getSchema());
        this.setSchemaURL(src.getSchemaURL());
    }

    @Override
    public void startProcess() throws XDocletException {
        Log log = LogUtil.getLog(XmlSubTask.class, "startProcess");
        super.getXJavaDoc().setDocEncoding(this.xmlEncoding);
        if (log.isDebugEnabled()) {
            log.debug((Object)("isValidateXML()=" + this.isValidateXML()));
            log.debug((Object)("getPublicId()=" + this.getPublicId()));
            log.debug((Object)("getSystemId()=" + this.getSystemId()));
            log.debug((Object)("getDtdURL()=" + this.getDtdURL()));
            log.debug((Object)("getSchema()=" + this.getSchema()));
            log.debug((Object)("getSchemaURL()=" + this.getSchemaURL()));
        }
        if (this.shouldValidate()) {
            XmlValidator validator = XmlValidator.getInstance();
            validator.reset();
            if (this.getPublicId() != null) {
                validator.registerDTD(this.getPublicId(), this.getDtdURL());
            }
            if (this.getSchemaURL() != null) {
                validator.registerSchema(this.getSchemaURL());
            }
        }
        IdTagsHandler.reset();
        super.startProcess();
    }

    protected void setSchemaURL(URL url) {
        this.schemaURL = url;
    }

    protected void setDtdURL(URL dtdURL) {
        this.dtdURL = dtdURL;
    }

    protected void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    protected void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    protected void engineFinished() throws XDocletException {
        Log log = LogUtil.getLog(XmlSubTask.class, "engineFinished");
        log.debug((Object)("isValidateXML()=" + this.isValidateXML()));
        if (this.shouldValidate()) {
            XmlValidator.getInstance().validate(this.getEngine().getOutput());
        }
    }

    private boolean shouldValidate() {
        return this.isValidateXML() && (this.getPublicId() != null && this.getDtdURL() != null || this.getSchemaURL() != null);
    }
}

