/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.evt;

import com.ctc.wstx.evt.WEvent;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.ProcessingInstruction;

public class WProcInstr
extends WEvent
implements ProcessingInstruction {
    final String mTarget;
    final String mData;

    public WProcInstr(Location loc, String target, String data) {
        super(loc);
        this.mTarget = target;
        this.mData = data;
    }

    @Override
    public String getData() {
        return this.mData;
    }

    @Override
    public String getTarget() {
        return this.mTarget;
    }

    @Override
    public int getEventType() {
        return 3;
    }

    @Override
    public boolean isProcessingInstruction() {
        return true;
    }

    @Override
    public void writeAsEncodedUnicode(Writer w) throws XMLStreamException {
        try {
            w.write("<?");
            w.write(this.mTarget);
            if (this.mData != null && this.mData.length() > 0) {
                w.write(this.mData);
            }
            w.write("?>");
        }
        catch (IOException ie) {
            this.throwFromIOE(ie);
        }
    }

    @Override
    public void writeUsing(XMLStreamWriter w) throws XMLStreamException {
        if (this.mData != null && this.mData.length() > 0) {
            w.writeProcessingInstruction(this.mTarget, this.mData);
        } else {
            w.writeProcessingInstruction(this.mTarget);
        }
    }
}

