/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.util;

import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;

public class ResourceTypeUtils {
    public static Configuration getDefaultPluginConfiguration(ResourceType resourceType) {
        ConfigurationTemplate template;
        ConfigurationDefinition pluginConfigurationDefinition = resourceType.getPluginConfigurationDefinition();
        if (pluginConfigurationDefinition != null && (template = pluginConfigurationDefinition.getDefaultTemplate()) != null) {
            return template.getConfiguration().deepCopy();
        }
        return new Configuration();
    }

    public static MeasurementDefinition getMeasurementDefinition(ResourceType resourceType, String metricName) {
        Set metricDefinitions = resourceType.getMetricDefinitions();
        for (MeasurementDefinition metricDefinition : metricDefinitions) {
            if (!metricDefinition.getName().equals(metricName)) continue;
            return metricDefinition;
        }
        return null;
    }

    public static OperationDefinition getOperationDefinition(ResourceType resourceType, String operationName) {
        Set operationDefinitions = resourceType.getOperationDefinitions();
        for (OperationDefinition operationDefinition : operationDefinitions) {
            if (!operationDefinition.getName().equals(operationName)) continue;
            return operationDefinition;
        }
        return null;
    }

    private ResourceTypeUtils() {
    }
}

