/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.BusinessKey;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.GetBusinessDetail;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class GetBusinessDetailHandler
extends AbstractHandler {
    public static final String TAG_NAME = "get_businessDetail";
    private HandlerMaker maker = null;

    protected GetBusinessDetailHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        GetBusinessDetail obj = new GetBusinessDetail();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String generic = element.getAttribute("generic");
        if (generic != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "businessKey");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("businessKey");
            obj.addBusinessKey((BusinessKey)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        GetBusinessDetail request = (GetBusinessDetail)object;
        String generic = request.getGeneric();
        generic = this.getGeneric(generic);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        AbstractHandler handler = null;
        element.setAttribute("generic", generic);
        Vector keyVector = request.getBusinessKeyVector();
        if (keyVector != null && keyVector.size() > 0) {
            handler = this.maker.lookup("businessKey");
            for (int i = 0; i < keyVector.size(); ++i) {
                handler.marshal(new BusinessKey((String)keyVector.elementAt(i)), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        GetBusinessDetail service = new GetBusinessDetail();
        service.addBusinessKey("1bd50f65-9671-41ae-8d13-b3b5a5afcda0");
        service.addBusinessKey(new BusinessKey("1fbe67e6-f8b5-4743-a23f-9c13e4273d9f"));
        System.out.println();
        RegistryObject regObject = service;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

