/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.request.FindTModel;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class FindTModelHandler
extends AbstractHandler {
    public static final String TAG_NAME = "find_tModel";
    private HandlerMaker maker = null;

    protected FindTModelHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        Name name;
        String maxRows;
        FindTModel obj = new FindTModel();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String generic = element.getAttribute("generic");
        if (generic != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        if ((maxRows = element.getAttribute("maxRows")) != null && maxRows.length() > 0) {
            obj.setMaxRows(maxRows);
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "name")).size() > 0 && (name = (Name)(handler = this.maker.lookup("name")).unmarshal((Element)nodeList.elementAt(0))) != null) {
            obj.setName(name);
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "findQualifiers")).size() > 0) {
            handler = this.maker.lookup("findQualifiers");
            obj.setFindQualifiers((FindQualifiers)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "identifierBag")).size() > 0) {
            handler = this.maker.lookup("identifierBag");
            obj.setIdentifierBag((IdentifierBag)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "categoryBag")).size() > 0) {
            handler = this.maker.lookup("categoryBag");
            obj.setCategoryBag((CategoryBag)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        CategoryBag catBag;
        IdentifierBag idBag;
        Name name;
        FindQualifiers qualifiers;
        FindTModel request = (FindTModel)object;
        String generic = request.getGeneric();
        generic = this.getGeneric(generic);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        AbstractHandler handler = null;
        element.setAttribute("generic", generic);
        int maxRows = request.getMaxRows();
        if (maxRows > 0) {
            element.setAttribute("maxRows", String.valueOf(maxRows));
        }
        if ((qualifiers = request.getFindQualifiers()) != null && qualifiers.size() > 0) {
            handler = this.maker.lookup("findQualifiers");
            handler.marshal(qualifiers, element);
        }
        if ((name = request.getName()) != null) {
            handler = this.maker.lookup("name");
            handler.marshal(name, element);
        }
        if ((idBag = request.getIdentifierBag()) != null) {
            handler = this.maker.lookup("identifierBag");
            handler.marshal(idBag, element);
        }
        if ((catBag = request.getCategoryBag()) != null) {
            handler = this.maker.lookup("categoryBag");
            handler.marshal(catBag, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        IdentifierBag idBag = new IdentifierBag();
        idBag.addKeyedReference(new KeyedReference("idBagKeyName", "idBagKeyValue"));
        idBag.addKeyedReference(new KeyedReference("uuid:3860b975-9e0c-4cec-bad6-87dfe00e3864", "idBagKeyName2", "idBagKeyValue2"));
        CategoryBag catBag = new CategoryBag();
        catBag.addKeyedReference(new KeyedReference("catBagKeyName", "catBagKeyValue"));
        catBag.addKeyedReference(new KeyedReference("uuid:8ff45356-acde-4a4c-86bf-f953611d20c6", "catBagKeyName2", "catBagKeyValue2"));
        FindTModel request = new FindTModel();
        request.setName(new Name("serviceNm2", "en"));
        request.addFindQualifier(new FindQualifier("sortByDateAsc"));
        request.addFindQualifier(new FindQualifier("andAllKeys"));
        request.setMaxRows(37);
        request.setIdentifierBag(idBag);
        request.setCategoryBag(catBag);
        System.out.println();
        RegistryObject regObject = request;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

