/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.business.BusinessEntityExt;
import org.apache.juddi.datatype.response.BusinessDetailExt;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class BusinessDetailExtHandler
extends AbstractHandler {
    public static final String TAG_NAME = "businessDetailExt";
    private HandlerMaker maker = null;

    protected BusinessDetailExtHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        BusinessDetailExt obj = new BusinessDetailExt();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setGeneric(element.getAttribute("generic"));
        obj.setOperator(element.getAttribute("operator"));
        String truncValue = element.getAttribute("truncated");
        if (truncValue != null) {
            obj.setTruncated(truncValue.equalsIgnoreCase("true"));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "businessEntityExt");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("businessEntityExt");
            obj.addBusinessEntityExt((BusinessEntityExt)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector vector;
        BusinessDetailExt detail = (BusinessDetailExt)object;
        String generic = detail.getGeneric();
        generic = this.getGeneric(generic);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        AbstractHandler handler = null;
        element.setAttribute("generic", generic);
        String operator = detail.getOperator();
        if (operator != null) {
            element.setAttribute("operator", operator);
        } else {
            element.setAttribute("operator", "");
        }
        boolean truncated = detail.isTruncated();
        if (truncated) {
            element.setAttribute("truncated", "true");
        }
        if ((vector = detail.getBusinessEntityExtVector()) != null && vector.size() > 0) {
            handler = this.maker.lookup("businessEntityExt");
            for (int i = 0; i < vector.size(); ++i) {
                handler.marshal((BusinessEntityExt)vector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
    }
}

