/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jms;

import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.jboss.test.jms.HornetQTestAdmin;
import org.jboss.test.jms.LegacyJMSTestAdmin;
import org.jboss.test.jms.TestRole;
import org.jboss.util.NestedRuntimeException;

public abstract class JMSTestAdmin {
    protected Map<String, TestRole[]> deployedTopics = new HashMap<String, TestRole[]>();
    protected Map<String, TestRole[]> deployedQueues = new HashMap<String, TestRole[]>();
    public static JMSTestAdmin admin;

    public static synchronized JMSTestAdmin getAdmin() {
        if (admin == null) {
            try {
                JMSTestAdmin tmpadmin = new HornetQTestAdmin();
                if (tmpadmin.isSupported()) {
                    admin = tmpadmin;
                } else {
                    tmpadmin = new LegacyJMSTestAdmin();
                    if (tmpadmin.isSupported()) {
                        admin = tmpadmin;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NestedRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        if (admin == null) {
            throw new RuntimeException("There is no supported TestAdmin for this JMS implementation");
        }
        return admin;
    }

    public abstract boolean isSupported();

    public abstract void createTopic(String var1, TestRole ... var2) throws Exception;

    public abstract void createTopic(String var1, String[] var2, TestRole ... var3) throws Exception;

    public abstract void deleteTopic(String var1) throws Exception;

    public abstract void createQueue(String var1, TestRole ... var2) throws Exception;

    public abstract void createQueue(String var1, String[] var2, TestRole ... var3) throws Exception;

    public abstract void deleteQueue(String var1) throws Exception;

    public abstract void destroyCreatedDestinations() throws Exception;

    public abstract void destroyEveryDestination() throws Exception;

    public abstract ObjectName createQueueJMXName(String var1);

    public abstract ObjectName createTopicJMXName(String var1);
}

