/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.annotations;

import java.net.URL;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.LoaderClassPath;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.plugins.annotations.GenericAnnotationResourceVisitor;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.annotations.AnnotationEnvironment;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericAnnotationDeployer
extends AbstractSimpleRealDeployer<Module> {
    private boolean forceAnnotations;
    private boolean keepAnnotations;
    private boolean checkInterfaces;

    public GenericAnnotationDeployer() {
        super(Module.class);
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.setOutput(AnnotationEnvironment.class);
        this.checkInterfaces = true;
    }

    public void setForceAnnotations(boolean forceAnnotations) {
        this.forceAnnotations = forceAnnotations;
    }

    public void setKeepAnnotations(boolean keepAnnotations) {
        this.keepAnnotations = keepAnnotations;
    }

    public void setCheckInterfaces(boolean checkInterfaces) {
        this.checkInterfaces = checkInterfaces;
    }

    protected GenericAnnotationResourceVisitor createGenericAnnotationResourceVisitor(DeploymentUnit unit, ClassPool pool, ClassLoader classLoader) {
        GenericAnnotationResourceVisitor visitor = new GenericAnnotationResourceVisitor(pool, classLoader);
        visitor.setForceAnnotations(this.forceAnnotations);
        visitor.setKeepAnnotations(this.keepAnnotations);
        visitor.setCheckInterfaces(this.checkInterfaces);
        return visitor;
    }

    protected ClassPool createClassPool(ClassLoader classLoader) {
        ClassPool pool = new ClassPool();
        LoaderClassPath classPath = new LoaderClassPath(classLoader);
        pool.insertClassPath((ClassPath)classPath);
        return pool;
    }

    protected void visitModule(DeploymentUnit unit, Module module, GenericAnnotationResourceVisitor visitor) {
        module.visit((ResourceVisitor)visitor, null, null, this.getUrls(unit));
    }

    protected URL[] getUrls(DeploymentUnit unit) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentUnit unit, Module module) throws DeploymentException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating AnnotationEnvironment for " + unit.getName() + ", module: " + module + ", force annotations: " + this.forceAnnotations));
        }
        ClassLoader classLoader = unit.getClassLoader();
        ClassPool pool = this.createClassPool(classLoader);
        GenericAnnotationResourceVisitor visitor = this.createGenericAnnotationResourceVisitor(unit, pool, classLoader);
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            this.visitModule(unit, module, visitor);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcl);
        }
        unit.addAttachment(AnnotationEnvironment.class, (Object)visitor.getEnv());
    }
}

