/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task.module;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jboss.tools.buildmagic.task.MissingAttributeException;
import org.jboss.tools.buildmagic.task.MissingElementException;
import org.jboss.tools.buildmagic.task.module.Module;
import org.jboss.tools.buildmagic.task.module.NamedElement;
import org.jboss.tools.buildmagic.task.util.ConditionalExecution;
import org.jboss.tools.buildmagic.task.util.TaskLogger;

public class ModuleConfig
extends Task {
    private TaskLogger log = new TaskLogger(this);
    private LinkedHashMap modules = new LinkedHashMap();
    private List groups = new LinkedList();
    private String property = "modules";
    private String selected;
    private ConditionalExecution cond = new ConditionalExecution(this);

    public void setProperty(String property) {
        this.property = property;
    }

    public void setSelected(String selected) {
        this.selected = selected;
    }

    public void addConfiguredModule(Module module) {
        this.modules.put(module.getName(), module);
    }

    public Group createGroup() {
        Group g = new Group(this);
        this.groups.add(g);
        return g;
    }

    public ConditionalExecution.Condition createCondition() {
        return this.cond.createCondition();
    }

    public void execute() throws BuildException {
        if (this.selected == null) {
            throw new MissingAttributeException("selected", this);
        }
        if (this.modules.size() == 0) {
            throw new MissingElementException("module", this);
        }
        if (this.groups.size() == 0) {
            throw new MissingElementException("group", this);
        }
        if (!this.cond.canExecute()) {
            return;
        }
        LinkedList moduleList = new LinkedList();
        StringTokenizer stok = new StringTokenizer(this.selected, ",");
        while (stok.hasMoreTokens()) {
            String name = stok.nextToken().trim();
            this.log.verbose("selected group: " + name);
            Group group = this.getGroup(name);
            if (group == null) {
                throw new BuildException("Invalid module group: " + this.selected);
            }
            this.log.debug("group: " + group);
            List allModules = group.getModules();
            if (allModules == null) {
                throw new BuildException("Invalid group: " + name);
            }
            moduleList.addAll(allModules);
        }
        this.log.debug("full module list: " + moduleList);
        String moduleListString = this.generatePropertyValue(moduleList);
        this.getProject().setProperty(this.property, moduleListString);
        this.getProject().addReference(this.property, moduleList);
        this.log.verbose("Module list: " + moduleListString);
    }

    protected String generatePropertyValue(List moduleList) {
        StringBuffer buff = new StringBuffer();
        Iterator iter = moduleList.iterator();
        while (iter.hasNext()) {
            Module mod = (Module)iter.next();
            if (mod == null) {
                throw new BuildException("Null module in list: " + moduleList);
            }
            buff.append(mod.getName());
            if (!iter.hasNext()) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    protected NamedElement getNamedElement(List list, String name) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            NamedElement elem = (NamedElement)iter.next();
            if (!elem.getName().equals(name)) continue;
            return elem;
        }
        return null;
    }

    protected Module getModule(String name) {
        return (Module)this.modules.get(name);
    }

    protected Group getGroup(String name) {
        return (Group)this.getNamedElement(this.groups, name);
    }

    protected class Group
    implements NamedElement {
        private List includes = new LinkedList();
        private ConditionalExecution cond;
        private Task parentTask;
        private String name;

        public Group(Task parentTask) {
            this.parentTask = parentTask;
            this.cond = new ConditionalExecution(parentTask);
        }

        public ConditionalExecution.Condition createCondition() {
            return this.cond.createCondition();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Include createInclude() {
            Include inc = new Include(this);
            this.includes.add(inc);
            return inc;
        }

        public void setModules(String modules) {
            Include inc = new Include(this);
            inc.setModules(modules);
            this.includes.add(inc);
        }

        public void setGroups(String groups) {
            Include inc = new Include(this);
            inc.setGroups(groups);
            this.includes.add(inc);
        }

        public List getModules() {
            LinkedList list = new LinkedList();
            if (!this.cond.canExecute()) {
                return list;
            }
            Iterator iter = this.includes.iterator();
            while (iter.hasNext()) {
                Include inc = (Include)iter.next();
                ModuleConfig.this.log.debug("adding modules from include: " + inc);
                list.addAll(inc.getModules());
            }
            return list;
        }

        public String toString() {
            return "{ name=" + this.name + ", includes=" + this.includes + " }";
        }

        protected class Include {
            protected ConditionalExecution cond;
            protected Group parentGroup;
            protected String modules = "";
            protected String groups = "";

            public Include(Group parentGroup) {
                this.parentGroup = parentGroup;
                this.cond = new ConditionalExecution(parentGroup.parentTask);
            }

            public ConditionalExecution.Condition createCondition() {
                return this.cond.createCondition();
            }

            public void setModules(String modules) {
                this.modules = modules;
            }

            public void setGroups(String groups) {
                this.groups = groups;
            }

            public List getGroups() {
                LinkedList<Group> list = new LinkedList<Group>();
                if (!this.cond.canExecute()) {
                    return list;
                }
                StringTokenizer stok = new StringTokenizer(this.groups, ",");
                while (stok.hasMoreTokens()) {
                    String name = stok.nextToken().trim();
                    Group group = ModuleConfig.this.getGroup(name);
                    if (group == null) {
                        throw new BuildException("Invalid group include: " + name);
                    }
                    list.add(group);
                    ModuleConfig.this.log.debug("adding group: " + group);
                }
                return list;
            }

            public List getModules() {
                LinkedList<Module> list = new LinkedList<Module>();
                if (!this.cond.canExecute()) {
                    return list;
                }
                StringTokenizer stok = new StringTokenizer(this.modules, ",");
                while (stok.hasMoreTokens()) {
                    String name = stok.nextToken().trim();
                    Module module = ModuleConfig.this.getModule(name);
                    if (module == null) {
                        throw new BuildException("Invalid module include: " + name);
                    }
                    list.add(module);
                    ModuleConfig.this.log.debug("adding module: " + module);
                }
                List groups = this.getGroups();
                Iterator iter = groups.iterator();
                while (iter.hasNext()) {
                    Group group = (Group)iter.next();
                    list.addAll(group.getModules());
                }
                return list;
            }

            public String toString() {
                return "{ modules=" + this.modules + ", groups=" + this.groups + " }";
            }
        }
    }
}

