/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jboss.tools.buildmagic.task.CallTarget;
import org.jboss.tools.buildmagic.task.MissingElementException;
import org.jboss.tools.buildmagic.task.Script;
import org.jboss.tools.buildmagic.task.util.TaskLogger;

public abstract class ContainerTask
extends Task
implements Cloneable {
    protected final TaskLogger log = new TaskLogger(this);
    protected List tasks = new LinkedList();

    public void setTarget(String target) {
        CallTarget call = this.createCall();
        call.setTarget(target);
        this.tasks.add(call);
    }

    public void setScript(String script) {
        Script task = this.createScript();
        task.addText(script);
        this.tasks.add(task);
    }

    public CallTarget createCall() {
        CallTarget task = (CallTarget)this.getProject().createTask("call");
        this.tasks.add(task);
        return task;
    }

    public Script createScript() {
        Script task = (Script)this.getProject().createTask("script");
        this.tasks.add(task);
        return task;
    }

    protected void validate() throws BuildException {
        if (this.tasks.size() == 0) {
            throw new MissingElementException("call' or 'task", this);
        }
    }

    protected void executeTasks() throws BuildException {
        Iterator iter = this.tasks.iterator();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            this.log.debug("executing sub-task: " + task);
            task.execute();
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

