/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.taskdefs.Property;
import org.jboss.tools.buildmagic.task.ResolveProperties;

public class Ant
extends org.apache.tools.ant.taskdefs.Ant {
    protected File dir = null;
    protected String antFile = null;
    protected String target = null;
    protected String output = null;
    protected Vector properties = new Vector();
    protected boolean inheritAll = true;
    protected Project project;

    public void init() {
        this.project = new Project();
        this.project.setJavaVersionProperty();
        this.project.addTaskDefinition("property", (Class)this.getProject().getTaskDefinitions().get("property"));
    }

    protected void reinit() {
        this.init();
        for (int i = 0; i < this.properties.size(); ++i) {
            Property p = (Property)this.properties.elementAt(i);
            Property newP = (Property)this.project.createTask("property");
            newP.setName(p.getName());
            if (p.getValue() != null) {
                newP.setValue(p.getValue());
            }
            if (p.getFile() != null) {
                newP.setFile(p.getFile());
            }
            if (p.getResource() != null) {
                newP.setResource(p.getResource());
            }
            this.properties.setElementAt(newP, i);
        }
    }

    protected void initializeProject() {
        Hashtable prop1;
        Vector listeners = this.getProject().getBuildListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            this.project.addBuildListener((BuildListener)listeners.elementAt(i));
        }
        if (this.output != null) {
            try {
                PrintStream out = new PrintStream(new FileOutputStream(this.output));
                DefaultLogger logger = new DefaultLogger();
                logger.setMessageOutputLevel(2);
                logger.setOutputPrintStream(out);
                logger.setErrorPrintStream(out);
                this.project.addBuildListener((BuildListener)logger);
            }
            catch (IOException ex) {
                this.log("Ant: Can't set output to " + this.output);
            }
        }
        Hashtable taskdefs = this.getProject().getTaskDefinitions();
        Enumeration et = taskdefs.keys();
        while (et.hasMoreElements()) {
            String taskName = (String)et.nextElement();
            Class taskClass = (Class)taskdefs.get(taskName);
            this.project.addTaskDefinition(taskName, taskClass);
        }
        Hashtable typedefs = this.getProject().getDataTypeDefinitions();
        Enumeration e = typedefs.keys();
        while (e.hasMoreElements()) {
            String typeName = (String)e.nextElement();
            Class typeClass = (Class)typedefs.get(typeName);
            this.project.addDataTypeDefinition(typeName, typeClass);
        }
        if (this.inheritAll) {
            prop1 = this.getProject().getProperties();
        } else {
            prop1 = this.getProject().getUserProperties();
            this.project.setSystemProperties();
        }
        e = prop1.keys();
        while (e.hasMoreElements()) {
            String arg = (String)e.nextElement();
            String value = (String)prop1.get(arg);
            if (this.inheritAll) {
                this.project.setProperty(arg, value);
                continue;
            }
            this.project.setUserProperty(arg, value);
        }
    }

    public void setInheritAll(boolean inherit) {
        this.inheritAll = inherit;
    }

    public File getBuildFile() throws BuildException {
        String filename = this.antFile;
        filename = filename == null ? "build.xml" : ResolveProperties.subst(filename, this.getProject());
        File file = new File("build.xml");
        if (!file.isAbsolute() && !(file = new File(filename = new File(this.dir, filename).getAbsolutePath())).isFile()) {
            throw new BuildException("Build file " + file + " not found.");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            if (this.project == null) {
                this.reinit();
            }
            if (this.dir == null) {
                this.dir = this.getProject().getBaseDir();
            }
            this.initializeProject();
            this.project.setBaseDir(this.dir);
            this.project.setUserProperty("basedir", this.dir.getAbsolutePath());
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                Property p = (Property)e.nextElement();
                p.execute();
            }
            this.antFile = this.antFile == null ? "build.xml" : ResolveProperties.subst(this.antFile, this.getProject());
            File file = new File(this.antFile);
            if (!file.isAbsolute()) {
                this.antFile = new File(this.dir, this.antFile).getAbsolutePath();
                file = new File(this.antFile);
                if (!file.isFile()) {
                    throw new BuildException("Build file " + file + " not found.");
                }
            }
            this.project.setUserProperty("ant.file", this.antFile);
            ProjectHelper.getProjectHelper().parse(this.project, (Object)new File(this.antFile));
            if (this.target == null) {
                this.target = this.project.getDefaultTarget();
            }
            if (this.project.getBaseDir().equals(this.getProject().getBaseDir()) && this.project.getProperty("ant.file").equals(this.getProject().getProperty("ant.file")) && this.getOwningTarget() != null && this.target.equals(this.getOwningTarget().getName())) {
                throw new BuildException("ant task calling its own parent target");
            }
            this.project.executeTarget(this.target);
        }
        finally {
            this.project = null;
        }
    }

    public Project getTargetProject() {
        return this.project;
    }

    public void addBuildListener(BuildListener l) {
        this.project.addBuildListener(l);
    }

    public void setDir(File d) {
        this.dir = d;
    }

    public void setAntfile(String s) {
        this.antFile = s;
    }

    public void setTarget(String s) {
        this.target = s;
    }

    public void setOutput(String s) {
        this.output = s;
    }

    public Property createProperty() {
        if (this.project == null) {
            this.reinit();
        }
        Property p = (Property)this.project.createTask("property");
        this.properties.addElement(p);
        return p;
    }
}

