/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionManager;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.recovery.Service;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.utils.Utility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;

public class ActionStatusService
implements Service {
    private static ObjectStore _objectStore = null;

    public ActionStatusService() {
        if (_objectStore == null) {
            _objectStore = TxControl.getStore();
        }
    }

    public int getTransactionStatus(String transactionType, String strUid) {
        int action_status = 9;
        if (strUid != null) {
            Uid tranUid = new Uid(strUid);
            action_status = transactionType == null || transactionType.equals("") ? this.getTranStatus(tranUid) : this.getActionStatus(tranUid, transactionType);
        }
        return action_status;
    }

    public void doWork(InputStream is, OutputStream os) throws IOException {
        block9: {
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            PrintWriter out = new PrintWriter(new OutputStreamWriter(os));
            try {
                out.println(Utility.intToHexString(Utility.getpid()));
                out.flush();
                String rmStatus = in.readLine();
                if (!rmStatus.equals("OK")) break block9;
                while (true) {
                    String transactionType = null;
                    String strUid = null;
                    try {
                        transactionType = in.readLine();
                        strUid = in.readLine();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    if (transactionType == null && strUid == null) {
                        return;
                    }
                    int status = this.getTransactionStatus(transactionType, strUid);
                    String strStatus = Integer.toString(status);
                    out.println(strStatus);
                    out.flush();
                    if (!tsLogger.arjLoggerI18N.isInfoEnabled()) continue;
                    tsLogger.arjLoggerI18N.info("com.arjuna.ats.arjuna.recovery.ActionStatusService_1", new Object[]{transactionType, strUid, strStatus});
                }
            }
            catch (IOException ex) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_7");
                }
            }
            catch (Exception ex) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_2", new Object[]{ex});
                }
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getActionStatus(Uid tranUid, String transactionType) {
        int action_status;
        block5: {
            action_status = 9;
            try {
                BasicAction basic_action = null;
                ActionManager actionManager = ActionManager.manager();
                synchronized (actionManager) {
                    basic_action = ActionManager.manager().get(tranUid);
                }
                action_status = basic_action != null ? basic_action.status() : this.getObjectStoreStatus(tranUid, transactionType);
            }
            catch (Exception ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block5;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_3", new Object[]{ex});
            }
        }
        return action_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTranStatus(Uid tranUid) {
        int action_status;
        block5: {
            action_status = 9;
            try {
                BasicAction basic_action = null;
                ActionManager actionManager = ActionManager.manager();
                synchronized (actionManager) {
                    basic_action = ActionManager.manager().get(tranUid);
                }
                action_status = basic_action != null ? basic_action.status() : this.getOsStatus(tranUid);
            }
            catch (Exception ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block5;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_3", new Object[]{ex});
            }
        }
        return action_status;
    }

    private int getOsStatus(Uid tranUid) {
        Vector<String> matchingUidTypeVector;
        Vector<Uid> matchingUidVector;
        int action_status;
        block19: {
            action_status = 9;
            matchingUidVector = new Vector<Uid>();
            matchingUidTypeVector = new Vector<String>();
            try {
                InputObjectState types = new InputObjectState();
                if (!_objectStore.allTypes(types)) break block19;
                String theTypeName = null;
                try {
                    boolean endOfList = false;
                    while (!endOfList) {
                        theTypeName = types.unpackString();
                        if (theTypeName.compareTo("") == 0) {
                            endOfList = true;
                            continue;
                        }
                        InputObjectState uids = new InputObjectState();
                        try {
                            boolean endOfUids = false;
                            if (!_objectStore.allObjUids(theTypeName, uids)) continue;
                            Uid theUid = new Uid(Uid.nullUid());
                            while (!endOfUids) {
                                theUid.unpack(uids);
                                if (theUid.equals(Uid.nullUid())) {
                                    endOfUids = true;
                                    continue;
                                }
                                if (!theUid.equals(tranUid)) continue;
                                matchingUidVector.addElement(tranUid);
                                matchingUidTypeVector.addElement(theTypeName);
                                if (!tsLogger.arjLoggerI18N.isInfoEnabled()) continue;
                                tsLogger.arjLoggerI18N.info("com.arjuna.ats.arjuna.recovery.ActionStatusService_4", new Object[]{tranUid});
                            }
                        }
                        catch (Exception ex) {
                            if (!tsLogger.arjLoggerI18N.isWarnEnabled()) continue;
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_5", new Object[]{ex});
                        }
                    }
                }
                catch (IOException ex) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_5", new Object[]{ex});
                    }
                }
                catch (Exception ex) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_5", new Object[]{ex});
                    }
                }
            }
            catch (Exception ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block19;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_5", new Object[]{ex});
            }
        }
        int uidVectorSize = matchingUidVector.size();
        int first_index = 0;
        if (uidVectorSize == 0) {
            action_status = 4;
        } else if (uidVectorSize == 1) {
            Uid uid = (Uid)matchingUidVector.get(first_index);
            String typeName = (String)matchingUidTypeVector.get(first_index);
            action_status = this.getObjectStoreStatus(uid, typeName);
        } else if (uidVectorSize > 1) {
            Uid rootUid = (Uid)matchingUidVector.get(first_index);
            String rootTypeName = (String)matchingUidTypeVector.get(first_index);
            for (int index = first_index + 1; index < uidVectorSize; ++index) {
                String typeName = (String)matchingUidTypeVector.get(index);
                if (typeName.length() >= rootTypeName.length()) continue;
                rootTypeName = typeName;
                rootUid = (Uid)matchingUidVector.get(index);
            }
            action_status = this.getObjectStoreStatus(rootUid, rootTypeName);
        }
        return action_status;
    }

    private int getObjectStoreStatus(Uid tranUid, String transactionType) {
        int action_status;
        block7: {
            action_status = 9;
            try {
                int osState = _objectStore.currentState(tranUid, transactionType);
                switch (osState) {
                    case 1: {
                        action_status = 7;
                        break;
                    }
                    case 0: {
                        action_status = 4;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        action_status = 5;
                    }
                }
            }
            catch (Exception ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block7;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_6", new Object[]{ex});
            }
        }
        return action_status;
    }
}

