/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.gandiva;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.gandiva.nameservice.NameService;
import com.arjuna.ats.arjuna.logging.tsLogger;
import java.io.IOException;
import java.io.PrintWriter;

public class ObjectName {
    public static final int SIGNED_NUMBER = 0;
    public static final int UNSIGNED_NUMBER = 1;
    public static final int STRING = 2;
    public static final int OBJECTNAME = 3;
    public static final int CLASSNAME = 4;
    public static final int UID = 5;
    private String _mech = null;
    private String _name = null;
    private NameService _nameService = null;
    private static final String _invalidString = "invalid";
    private static final String nameServiceString = "NameServiceImple";
    private static final String nameDelim = ":";
    private static final String nullString = "";
    private static final ObjectName _invalid = new ObjectName("invalid:invalid");

    public ObjectName(String objectName) {
        if (objectName == null) {
            this._mech = _invalidString;
            this._name = _invalidString;
        } else {
            int mechLength = objectName.indexOf(nameDelim);
            if (mechLength != -1) {
                int nameLength = objectName.length() - mechLength - nameDelim.length();
                this._mech = new String(objectName.substring(0, mechLength));
                this._name = nameLength > 0 ? objectName.substring(mechLength + nameDelim.length(), objectName.length()) : new String(nullString);
            }
        }
        this.initNameService();
    }

    public ObjectName(ObjectName objectName) {
        this.copy(objectName);
    }

    public ObjectName(NameService nameService, String objectName) {
        if (nameService != null && objectName != null) {
            this._nameService = nameService;
            String fullMechName = this._nameService.impleClassName().stringForm();
            int appendedString = fullMechName.indexOf(nameServiceString);
            this._mech = new String(fullMechName.substring(0, appendedString - fullMechName.length()));
            this._name = new String(objectName);
        } else {
            if (nameService == null) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.gandiva.ObjectName_1");
            }
            if (objectName == null) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.gandiva.ObjectName_2");
            }
            this._mech = _invalidString;
            this._name = _invalidString;
        }
    }

    public int attributeType(String attrName) throws NullPointerException, IOException {
        if (this._nameService != null) {
            return this._nameService.attributeType(this._name, attrName);
        }
        throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
    }

    public String firstAttributeName() throws NullPointerException, IOException {
        if (this._nameService != null) {
            return this._nameService.firstAttributeName(this._name);
        }
        throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
    }

    public String nextAttributeName(String attrName) throws NullPointerException, IOException {
        if (this._nameService != null) {
            return this._nameService.nextAttributeName(this._name, attrName);
        }
        throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
    }

    public long getLongAttribute(String attrName) throws NullPointerException, IOException {
        if (this._nameService != null) {
            return this._nameService.getLongAttribute(this._name, attrName);
        }
        throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
    }

    public String getStringAttribute(String attrName) throws NullPointerException, IOException {
        if (this._nameService != null) {
            return this._nameService.getStringAttribute(this._name, attrName);
        }
        throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
    }

    public ObjectName getObjectNameAttribute(String attrName) throws NullPointerException, IOException {
        if (this._nameService != null) {
            return this._nameService.getObjectNameAttribute(this._name, attrName);
        }
        throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
    }

    public ClassName getClassNameAttribute(String attrName) throws NullPointerException, IOException {
        if (this._nameService != null) {
            return this._nameService.getClassNameAttribute(this._name, attrName);
        }
        throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
    }

    public Uid getUidAttribute(String attrName) throws NullPointerException, IOException {
        if (this._nameService != null) {
            return this._nameService.getUidAttribute(this._name, attrName);
        }
        throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
    }

    public void setLongAttribute(String attrName, long value) throws NullPointerException, IOException {
        if (this._nameService == null) {
            throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
        }
        this._name = this._nameService.setLongAttribute(this._name, attrName, value);
    }

    public void setStringAttribute(String attrName, String value) throws NullPointerException, IOException {
        if (this._nameService == null) {
            throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
        }
        this._name = this._nameService.setStringAttribute(this._name, attrName, value);
    }

    public void setObjectNameAttribute(String attrName, ObjectName value) throws NullPointerException, IOException {
        if (this._nameService == null) {
            throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
        }
        this._name = this._nameService.setObjectNameAttribute(this._name, attrName, value);
    }

    public void setClassNameAttribute(String attrName, ClassName value) throws NullPointerException, IOException {
        if (this._nameService == null) {
            throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
        }
        this._name = this._nameService.setClassNameAttribute(this._name, attrName, value);
    }

    public void setUidAttribute(String attrName, Uid value) throws NullPointerException, IOException {
        if (this._nameService == null) {
            throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
        }
        this._name = this._nameService.setUidAttribute(this._name, attrName, value);
    }

    public boolean removeAttribute(String attrName) throws IOException {
        if (this._nameService != null) {
            this._name = this._nameService.removeAttribute(this._name, attrName);
            if (this._name != null) {
                return true;
            }
        }
        return false;
    }

    public String uniqueAttributeName() throws NullPointerException, IOException {
        if (this._nameService != null) {
            return this._nameService.uniqueAttributeName(this._name);
        }
        throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
    }

    public static ObjectName uniqueObjectName(String mech) throws NullPointerException, IOException {
        NameService nameService = null;
        ObjectName objectName = ObjectName.invalid();
        if (mech != null && mech.compareTo(_invalidString) != 0) {
            String nameServiceMech = mech + nameServiceString;
            ClassName nameServiceMechClassName = new ClassName(nameServiceMech);
            nameService = NameService.create(nameServiceMechClassName);
            if (nameService != null) {
                objectName = nameService.uniqueObjectName();
            }
            nameService = null;
        }
        return objectName;
    }

    public synchronized void copy(ObjectName objectName) {
        if (objectName == this) {
            return;
        }
        this._nameService = null;
        this._mech = null;
        this._name = null;
        if (objectName._mech != null) {
            this._mech = new String(objectName._mech);
            if (objectName._nameService != null) {
                this._nameService = new NameService(objectName._nameService);
            }
        }
        if (objectName._name != null) {
            this._name = new String(objectName._name);
        }
        this.initNameService();
    }

    public boolean equals(Object o) {
        if (o instanceof ObjectName) {
            return this.equals((ObjectName)o);
        }
        return false;
    }

    public boolean equals(ObjectName objectName) {
        return (this._name == objectName._name || this._name != null && objectName._name != null && this._name.compareTo(objectName._name) == 0) && (this._mech == objectName._mech || this._mech != null && objectName._mech != null && this._mech.compareTo(objectName._mech) == 0);
    }

    public boolean notEquals(ObjectName objectName) {
        return this._name != objectName._name && (this._name == null || objectName._name == null || this._name.compareTo(objectName._name) != 0) || this._mech != objectName._mech && (this._mech == null || objectName._mech == null || this._mech.compareTo(objectName._mech) != 0);
    }

    public String getMechanismName() {
        return this._mech;
    }

    public String stringForm() {
        return new String(this._mech + nameDelim + this._name);
    }

    public static ObjectName invalid() {
        return _invalid;
    }

    public void print(PrintWriter strm) {
        strm.print("<ObjectName:" + this._mech + nameDelim + this._name + ">");
    }

    public String toString() {
        return this.stringForm();
    }

    public static void print(int t) {
        switch (t) {
            case 0: {
                System.out.print("SIGNED_NUMBER");
                break;
            }
            case 1: {
                System.out.print("UNSIGNED_NUMBER");
                break;
            }
            case 2: {
                System.out.print("STRING");
                break;
            }
            case 3: {
                System.out.print("OBJECTNAME");
                break;
            }
            case 4: {
                System.out.print("CLASSNAME");
                break;
            }
            case 5: {
                System.out.print("UID");
                break;
            }
            default: {
                System.out.print("Unknown");
            }
        }
    }

    private final void initNameService() {
        if (this._nameService != null) {
            return;
        }
        if (this._mech != null && this._mech.compareTo(_invalidString) != 0) {
            String nameServiceMech = new String(this._mech + nameServiceString);
            ClassName nameServiceMechClassName = new ClassName(nameServiceMech);
            this._nameService = NameService.create(nameServiceMechClassName);
            Object var1_1 = null;
        } else {
            this._nameService = null;
        }
    }
}

