/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.calendar;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import org.quartz.Calendar;
import org.quartz.impl.calendar.BaseCalendar;

public class HolidayCalendar
extends BaseCalendar
implements Calendar,
Serializable {
    private TreeSet dates = new TreeSet();

    public HolidayCalendar() {
    }

    public HolidayCalendar(Calendar baseCalendar) {
        this.setBaseCalendar(baseCalendar);
    }

    public boolean isTimeIncluded(long timeStamp) {
        if (!super.isTimeIncluded(timeStamp)) {
            return false;
        }
        Date lookFor = HolidayCalendar.buildHoliday(new Date(timeStamp));
        return !this.dates.contains(lookFor);
    }

    public long getNextIncludedTime(long timeStamp) {
        long baseTime = super.getNextIncludedTime(timeStamp);
        if (baseTime > 0L && baseTime > timeStamp) {
            timeStamp = baseTime;
        }
        long newTimeStamp = HolidayCalendar.buildHoliday(timeStamp);
        java.util.Calendar day = HolidayCalendar.getJavaCalendar(newTimeStamp);
        while (!this.isTimeIncluded(day.getTime().getTime())) {
            day.add(5, 1);
        }
        return day.getTime().getTime();
    }

    public void addExcludedDate(Date excludedDate) {
        Date date = HolidayCalendar.buildHoliday(excludedDate);
        this.dates.add(date);
    }

    public void removeExcludedDate(Date dateToRemove) {
        Date date = HolidayCalendar.buildHoliday(dateToRemove);
        this.dates.remove(date);
    }

    public SortedSet getExcludedDates() {
        return Collections.unmodifiableSortedSet(this.dates);
    }
}

