/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jms.integration.support.ejb20;

import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;

public class StatefulBean
implements SessionBean {
    private static final long serialVersionUID = 7089862891437892169L;

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
    }

    public void ejbCreate() throws CreateException {
    }

    public void sendTestMessage(String message) throws JMSException {
        try {
            InitialContext ctx = new InitialContext();
            QueueConnectionFactory cf = (QueueConnectionFactory)ctx.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            Destination queue = (Destination)ctx.lookup("queue/A_Integration");
            Connection conn = cf.createConnection();
            Session session = conn.createSession(false, 1);
            MessageProducer producer = session.createProducer(queue);
            TextMessage msg = session.createTextMessage(message);
            producer.send((Message)msg);
            conn.close();
        }
        catch (Exception e) {
            JMSException jmsE = new JMSException(e.getMessage());
            jmsE.initCause((Throwable)e);
            throw jmsE;
        }
    }

    public String receiveMessage(String jndiQueue, boolean transact, boolean commit) throws JMSException {
        UserTransaction userTrans = null;
        try {
            InitialContext ctx = new InitialContext();
            if (transact) {
                userTrans = (UserTransaction)ctx.lookup("UserTransaction");
                userTrans.begin();
            }
            QueueConnectionFactory cf = (QueueConnectionFactory)ctx.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            Destination queue = (Destination)ctx.lookup(jndiQueue);
            Connection conn = cf.createConnection();
            conn.start();
            Session session = conn.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer(queue);
            TextMessage txt = (TextMessage)consumer.receive(10000L);
            String strReturn = txt != null ? txt.getText() : null;
            System.out.println("StrReturn = " + strReturn);
            if (transact) {
                if (commit) {
                    userTrans.commit();
                } else {
                    userTrans.rollback();
                }
            }
            conn.close();
            return strReturn;
        }
        catch (Exception e) {
            JMSException jmsE = new JMSException(e.getMessage());
            jmsE.initCause((Throwable)e);
            throw jmsE;
        }
    }
}

