/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class ReclosableLatch
extends AbstractQueuedSynchronizer {
    private static final long serialVersionUID = 1744280161777661090L;
    private static final int OPEN_STATE = 0;
    private static final int CLOSED_STATE = 1;

    public ReclosableLatch() {
        this.setState(1);
    }

    public ReclosableLatch(boolean defaultOpen) {
        this.setState(defaultOpen ? 0 : 1);
    }

    public final int tryAcquireShared(int ignored) {
        return this.getState() == 0 ? 1 : -1;
    }

    public final boolean tryReleaseShared(int state) {
        this.setState(state);
        return true;
    }

    public final void open() {
        this.releaseShared(0);
    }

    public final void close() {
        this.releaseShared(1);
    }

    public final void await() throws InterruptedException {
        this.acquireSharedInterruptibly(1);
    }

    public final boolean await(long time, TimeUnit unit) throws InterruptedException {
        return this.tryAcquireSharedNanos(1, unit.toNanos(time));
    }

    public boolean isOpen() {
        return this.getState() == 0;
    }
}

