/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.OrderedSynchronizationHandler;
import org.jboss.cache.transaction.TransactionContext;
import org.jboss.cache.util.Immutables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransactionContext
implements TransactionContext {
    private Transaction ltx = null;
    private Option option;
    private OrderedSynchronizationHandler orderedSynchronizationHandler;
    private boolean forceAsyncReplication = false;
    private boolean forceSyncReplication = false;
    private List<WriteCommand> modificationList;
    private List<WriteCommand> localModifications;
    private LinkedHashSet transactionLocks;
    private List<Fqn> dummyNodesCreatedByCacheLoader;
    private List<Fqn> removedNodes = null;

    public AbstractTransactionContext(Transaction tx) throws SystemException, RollbackException {
        this.ltx = tx;
        this.orderedSynchronizationHandler = new OrderedSynchronizationHandler(tx);
    }

    @Override
    public void addModification(WriteCommand command) {
        if (command == null) {
            return;
        }
        if (this.modificationList == null) {
            this.modificationList = new LinkedList<WriteCommand>();
        }
        this.modificationList.add(command);
    }

    @Override
    public List<WriteCommand> getModifications() {
        if (this.modificationList == null) {
            return Collections.emptyList();
        }
        return this.modificationList;
    }

    @Override
    public void addLocalModification(WriteCommand command) {
        if (command == null) {
            throw new NullPointerException("Command is null!");
        }
        if (this.localModifications == null) {
            this.localModifications = new LinkedList<WriteCommand>();
        }
        this.localModifications.add(command);
    }

    @Override
    public List<WriteCommand> getLocalModifications() {
        if (this.localModifications == null) {
            return Collections.emptyList();
        }
        return this.localModifications;
    }

    @Override
    public void addRemovedNode(Fqn fqn) {
        if (fqn == null) {
            throw new NullPointerException("Fqn is null!");
        }
        if (this.removedNodes == null) {
            this.removedNodes = new LinkedList<Fqn>();
        }
        this.removedNodes.add(fqn);
    }

    @Override
    public List<Fqn> getRemovedNodes() {
        if (this.removedNodes == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Fqn>(this.removedNodes);
    }

    @Override
    public void setTransaction(Transaction tx) {
        this.ltx = tx;
    }

    @Override
    public Transaction getTransaction() {
        return this.ltx;
    }

    @Override
    public void addLock(Object lock) {
        if (this.transactionLocks == null) {
            this.transactionLocks = new LinkedHashSet(5);
        }
        this.transactionLocks.add(lock);
    }

    @Override
    public void removeLock(Object lock) {
        if (this.transactionLocks != null) {
            this.transactionLocks.remove(lock);
        }
    }

    @Override
    public void clearLocks() {
        if (this.transactionLocks != null) {
            this.transactionLocks.clear();
        }
    }

    @Override
    public boolean hasLock(Object lock) {
        return this.transactionLocks != null && this.transactionLocks.contains(lock);
    }

    @Override
    public void addAllLocks(List newLocks) {
        if (this.transactionLocks == null) {
            this.transactionLocks = new LinkedHashSet(5);
        }
        this.transactionLocks.addAll(newLocks);
    }

    @Override
    public List getLocks() {
        return this.transactionLocks == null || this.transactionLocks.isEmpty() ? Collections.emptyList() : Immutables.immutableListConvert(this.transactionLocks);
    }

    @Override
    public boolean isForceAsyncReplication() {
        return this.forceAsyncReplication;
    }

    @Override
    public void setForceAsyncReplication(boolean forceAsyncReplication) {
        this.forceAsyncReplication = forceAsyncReplication;
        if (forceAsyncReplication) {
            this.forceSyncReplication = false;
        }
    }

    @Override
    public boolean isForceSyncReplication() {
        return this.forceSyncReplication;
    }

    @Override
    public void setForceSyncReplication(boolean forceSyncReplication) {
        this.forceSyncReplication = forceSyncReplication;
        if (forceSyncReplication) {
            this.forceAsyncReplication = false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransactionEntry\nmodificationList: ").append(this.modificationList);
        return sb.toString();
    }

    @Override
    public void addDummyNodeCreatedByCacheLoader(Fqn fqn) {
        if (this.dummyNodesCreatedByCacheLoader == null) {
            this.dummyNodesCreatedByCacheLoader = new LinkedList<Fqn>();
        }
        this.dummyNodesCreatedByCacheLoader.add(fqn);
    }

    @Override
    public List<Fqn> getDummyNodesCreatedByCacheLoader() {
        if (this.dummyNodesCreatedByCacheLoader == null) {
            return Collections.emptyList();
        }
        return this.dummyNodesCreatedByCacheLoader;
    }

    @Override
    public void setOption(Option o) {
        this.option = o;
    }

    @Override
    public Option getOption() {
        return this.option;
    }

    @Override
    public OrderedSynchronizationHandler getOrderedSynchronizationHandler() {
        return this.orderedSynchronizationHandler;
    }

    @Override
    public void setOrderedSynchronizationHandler(OrderedSynchronizationHandler orderedSynchronizationHandler) {
        this.orderedSynchronizationHandler = orderedSynchronizationHandler;
    }

    @Override
    public boolean hasModifications() {
        return this.modificationList != null && !this.modificationList.isEmpty();
    }

    @Override
    public boolean hasLocalModifications() {
        return this.localModifications != null && !this.localModifications.isEmpty();
    }

    @Override
    public boolean hasAnyModifications() {
        return this.hasModifications() || this.hasLocalModifications();
    }

    @Override
    public void reset() {
        this.orderedSynchronizationHandler = null;
        this.modificationList = null;
        this.localModifications = null;
        this.option = null;
        if (this.transactionLocks != null) {
            this.transactionLocks.clear();
        }
        if (this.dummyNodesCreatedByCacheLoader != null) {
            this.dummyNodesCreatedByCacheLoader.clear();
        }
        if (this.removedNodes != null) {
            this.removedNodes.clear();
        }
    }
}

