/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionContext;

public class ReplicationInterceptor
extends BaseRpcInterceptor {
    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        if (!this.skipReplicationOfTransactionMethod(ctx)) {
            this.replicateCall(ctx, command, this.configuration.isSyncCommitPhase(), ctx.getOptionOverrides(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        TransactionContext transactionContext = ctx.getTransactionContext();
        if (transactionContext.hasLocalModifications()) {
            PrepareCommand replicablePrepareCommand = command.copy();
            replicablePrepareCommand.removeModifications(transactionContext.getLocalModifications());
            command = replicablePrepareCommand;
        }
        if (!this.skipReplicationOfTransactionMethod(ctx)) {
            this.runPreparePhase(command, command.getGlobalTransaction(), ctx);
        }
        return retVal;
    }

    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!this.skipReplicationOfTransactionMethod(ctx) && !ctx.isLocalRollbackOnly()) {
            this.replicateCall(ctx, command, this.configuration.isSyncRollbackPhase(), ctx.getOptionOverrides());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        boolean local = this.isLocalModeForced(ctx);
        if (local && ctx.getTransaction() == null) {
            return this.invokeNextInterceptor(ctx, command);
        }
        if (this.isTransactionalAndLocal(ctx)) {
            Object returnValue = this.invokeNextInterceptor(ctx, command);
            ctx.getTransactionContext().setForceAsyncReplication(true);
            if (local) {
                ctx.getTransactionContext().addLocalModification(command);
            }
            return returnValue;
        }
        return this.handleCrudMethod(ctx, command, true);
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command, false);
    }

    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command, false);
    }

    public Object visitMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command, false);
    }

    public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command, false);
    }

    public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command, false);
    }

    public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command, false);
    }

    private Object handleCrudMethod(InvocationContext ctx, VisitableCommand command, boolean forceAsync) throws Throwable {
        boolean local = this.isLocalModeForced(ctx);
        if (local && ctx.getTransaction() == null) {
            return this.invokeNextInterceptor(ctx, command);
        }
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (ctx.getTransaction() == null && ctx.isOriginLocal()) {
            if (this.trace) {
                this.log.trace((Object)("invoking method " + command.getClass().getSimpleName() + ", members=" + this.rpcManager.getMembers() + ", mode=" + (Object)((Object)this.configuration.getCacheMode()) + ", exclude_self=" + true + ", timeout=" + this.configuration.getSyncReplTimeout()));
            }
            this.replicateCall(ctx, command, !forceAsync && this.isSynchronous(ctx.getOptionOverrides()), ctx.getOptionOverrides());
        } else if (local) {
            ctx.getTransactionContext().addLocalModification((WriteCommand)command);
        }
        return returnValue;
    }

    protected void runPreparePhase(PrepareCommand prepareMethod, GlobalTransaction gtx, InvocationContext ctx) throws Throwable {
        boolean async;
        boolean bl = async = this.configuration.getCacheMode() == Configuration.CacheMode.REPL_ASYNC;
        if (this.trace) {
            this.log.trace((Object)("(" + this.rpcManager.getLocalAddress() + "): running remote prepare for global tx " + gtx + " with async mode=" + async));
        }
        this.replicateCall(ctx, prepareMethod, !async, ctx.getOptionOverrides());
    }
}

