/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionContext;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class OptimisticInterceptor
extends CommandInterceptor {
    protected TransactionManager txManager;
    protected TransactionTable txTable;
    protected LockManager lockManager;

    @Inject
    void injectDependencies(TransactionManager txManager, TransactionTable txTable, LockManager lockManager) {
        this.txManager = txManager;
        this.txTable = txTable;
        this.lockManager = lockManager;
    }

    protected TransactionWorkspace getTransactionWorkspace(InvocationContext ctx) throws CacheException {
        OptimisticTransactionContext transactionContext = (OptimisticTransactionContext)ctx.getTransactionContext();
        if (transactionContext == null) {
            throw new CacheException("Unable to map global transaction " + ctx.getGlobalTransaction() + " to transaction entry when trying to retrieve transaction workspace.");
        }
        return transactionContext.getTransactionWorkSpace();
    }

    protected void greedyGetFqns(List<Fqn> list, NodeSPI<?, ?> n, Fqn newBase) {
        list.add(n.getFqn());
        Fqn<Object> newFqn = Fqn.fromRelativeElements(newBase, n.getFqn().getLastElement());
        list.add(newFqn);
        for (NodeSPI<?, ?> child : n.getChildrenDirect()) {
            this.greedyGetFqns(list, child, newFqn);
        }
    }

    protected GlobalTransaction getGlobalTransaction(InvocationContext ctx) throws CacheException {
        Transaction tx = ctx.getTransaction();
        if (tx == null) {
            throw new CacheException("Transaction associated with the current invocation is null!");
        }
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        if (gtx == null) {
            throw new CacheException("GlobalTransaction associated with the current invocation is null!");
        }
        return gtx;
    }

    protected void undeleteWorkspaceNode(WorkspaceNode nodeToUndelete, TransactionWorkspace workspace) {
        this.undeleteWorkspaceNode(nodeToUndelete, workspace.getNode(nodeToUndelete.getFqn().getParent()));
    }

    protected void undeleteWorkspaceNode(WorkspaceNode nodeToUndelete, WorkspaceNode parent) {
        nodeToUndelete.setRemoved(false);
        nodeToUndelete.clearData();
        parent.addChild(nodeToUndelete);
        nodeToUndelete.markAsResurrected(true);
    }

    protected WorkspaceNode lockAndCreateWorkspaceNode(NodeFactory<?, ?> nodeFactory, NodeSPI node, TransactionWorkspace<?, ?> workspace, GlobalTransaction gtx, long timeout) {
        boolean locked;
        try {
            locked = this.lockManager.lock(node, LockType.READ, (Object)gtx, timeout);
        }
        catch (InterruptedException e) {
            locked = this.lockManager.getReadOwners(node).contains(gtx);
        }
        if (!locked) {
            throw new TimeoutException("Unable to lock node " + node.getFqn() + " after timeout " + timeout + " for copying into workspace");
        }
        WorkspaceNode<?, ?> wn = nodeFactory.createWrappedNode(node, workspace);
        this.lockManager.unlock(node, (Object)gtx);
        return wn;
    }
}

